/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.scmpublish.AbstractScmPublishMojo;
import org.apache.maven.plugins.scmpublish.ScmPublishInventory;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="publish", defaultPhase=LifecyclePhase.POST_SITE, aggregator=true)
public class ScmPublishPublishMojo
extends AbstractScmPublishMojo {
    @Parameter(property="scmpublish.dryRun")
    private boolean dryRun;
    @Parameter(property="scmpublish.skipCheckin")
    private boolean skipCheckin;
    @Parameter(property="scmpublish.checkinComment", defaultValue="Site checkin for project ${project.name}")
    private String checkinComment;
    private static final String[] NORMALIZE_EXTENSIONS = new String[]{"html", "css", "js"};
    @Parameter
    protected String[] extraNormalizeExtensions;

    private File relativize(File base, File file) {
        return new File(base.toURI().relativize(file.toURI()).getPath());
    }

    protected boolean requireNormalizeNewlines(File f) throws IOException {
        List<String> extensions = Arrays.asList(NORMALIZE_EXTENSIONS);
        if (this.extraNormalizeExtensions != null) {
            extensions.addAll(Arrays.asList(this.extraNormalizeExtensions));
        }
        return FilenameUtils.isExtension((String)f.getName(), extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalizeNewlines(File f) throws IOException {
        File tmpFile = null;
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            String line;
            tmpFile = File.createTempFile("maven-site-scm-plugin-", ".tmp");
            FileUtils.copyFile((File)f, (File)tmpFile);
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), this.siteOutputEncoding));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.siteOutputEncoding));
            while ((line = in.readLine()) != null) {
                if (in.ready()) {
                    out.println(line);
                    continue;
                }
                out.print(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            FileUtils.deleteQuietly((File)tmpFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((Reader)in);
        FileUtils.deleteQuietly((File)tmpFile);
    }

    private void normalizeNewLines(Set<File> files) throws MojoFailureException {
        for (File f : files) {
            try {
                if (!this.requireNormalizeNewlines(f)) continue;
                this.normalizeNewlines(f);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to normalize newlines in " + f.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    @Override
    public void scmPublishExecute() throws MojoExecutionException, MojoFailureException {
        if (this.siteOutputEncoding == null) {
            this.getLog().warn((CharSequence)"No output encoding, defaulting to UTF-8.");
            this.siteOutputEncoding = "utf-8";
        }
        List<File> inventory = ScmPublishInventory.readInventory(this.inventoryFile);
        List<File> newInventory = ScmPublishInventory.listInventoryFiles(this.checkoutDirectory, this.scmProvider.getScmSpecificFilename());
        HashSet<File> deleted = new HashSet<File>(inventory);
        deleted.removeAll(newInventory);
        HashSet<File> added = new HashSet<File>(newInventory);
        added.removeAll(inventory);
        HashSet<File> updated = new HashSet<File>(newInventory);
        updated.retainAll(inventory);
        this.logInfo("Publish files: %d addition(s), %d update(s), %d delete(s)", added.size(), updated.size(), deleted.size());
        if (this.isDryRun()) {
            for (File addedFile : added) {
                this.logInfo("Added %s", addedFile.getAbsolutePath());
            }
            for (File deletedFile : deleted) {
                this.logInfo("Deleted %s", deletedFile.getAbsolutePath());
            }
            for (File updatedFile : updated) {
                this.logInfo("Updated %s", updatedFile.getAbsolutePath());
            }
            return;
        }
        if (!added.isEmpty()) {
            this.normalizeNewLines(added);
            this.addFiles(added);
        }
        if (!deleted.isEmpty()) {
            this.deleteFiles(deleted);
        }
        this.normalizeNewLines(updated);
        this.checkinFiles();
    }

    protected void checkinFiles() throws MojoExecutionException {
        if (this.skipCheckin) {
            return;
        }
        ScmFileSet updatedFileSet = new ScmFileSet(this.checkoutDirectory);
        try {
            this.logInfo("Checkin to the scm", new Object[0]);
            CheckInScmResult checkinResult = this.scmProvider.checkIn(this.scmRepository, updatedFileSet, (ScmVersion)new ScmBranch(this.scmBranch), this.checkinComment);
            if (!checkinResult.isSuccess()) {
                this.logError("checkin operation failed: %s", checkinResult.getProviderMessage() + " " + checkinResult.getCommandOutput());
                throw new MojoExecutionException("Failed to checkin files: " + checkinResult.getProviderMessage() + " " + checkinResult.getCommandOutput());
            }
            this.logInfo("Checkin %d file(s) to revision: %s", checkinResult.getCheckedInFiles().size(), checkinResult.getScmRevision());
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to perform checkin SCM", (Exception)((Object)e));
        }
    }

    protected void deleteFiles(Collection<File> deleted) throws MojoExecutionException {
        if (this.skipDeletedFiles) {
            this.logInfo("deleting files is skipped", new Object[0]);
            return;
        }
        ArrayList<File> deletedList = new ArrayList<File>();
        for (File f : deleted) {
            deletedList.add(this.relativize(this.checkoutDirectory, f));
        }
        ScmFileSet deletedFileSet = new ScmFileSet(this.checkoutDirectory, deletedList);
        try {
            this.getLog().debug((CharSequence)("deleting files: " + deletedList));
            RemoveScmResult deleteResult = this.scmProvider.remove(this.scmRepository, deletedFileSet, "Deleting obsolete site files.");
            if (!deleteResult.isSuccess()) {
                this.logError("delete operation failed: %s", deleteResult.getProviderMessage() + " " + deleteResult.getCommandOutput());
                throw new MojoExecutionException("Failed to delete files: " + deleteResult.getProviderMessage() + " " + deleteResult.getCommandOutput());
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to delete removed files to SCM", (Exception)((Object)e));
        }
    }

    protected void addFiles(Collection<File> added) throws MojoFailureException, MojoExecutionException {
        ArrayList<File> addedList = new ArrayList<File>();
        HashSet<File> createdDirs = new HashSet<File>();
        TreeSet<File> dirsToAdd = new TreeSet<File>();
        createdDirs.add(this.relativize(this.checkoutDirectory, this.checkoutDirectory));
        for (File f : added) {
            File relativized;
            File dir = f.getParentFile();
            while (!dir.equals(this.checkoutDirectory) && createdDirs.add(relativized = this.relativize(this.checkoutDirectory, dir))) {
                dirsToAdd.add(relativized);
                dir = dir.getParentFile();
            }
            addedList.add(this.relativize(this.checkoutDirectory, f));
        }
        for (File relativized : dirsToAdd) {
            try {
                ScmFileSet fileSet = new ScmFileSet(this.checkoutDirectory, relativized);
                this.getLog().debug((CharSequence)("scm add directory: " + relativized));
                AddScmResult addDirResult = this.scmProvider.add(this.scmRepository, fileSet, "Adding directory");
                if (addDirResult.isSuccess()) continue;
                this.getLog().debug((CharSequence)(" Error adding directory " + relativized + ": " + addDirResult.getCommandOutput()));
            }
            catch (ScmException e) {}
        }
        addedList.removeAll(dirsToAdd);
        ScmFileSet addedFileSet = new ScmFileSet(this.checkoutDirectory, addedList);
        this.getLog().debug((CharSequence)("scm add files: " + addedList));
        try {
            CommandParameters commandParameters = new CommandParameters();
            commandParameters.setString(CommandParameter.MESSAGE, "Adding new site files.");
            commandParameters.setString(CommandParameter.FORCE_ADD, Boolean.TRUE.toString());
            AddScmResult addResult = this.scmProvider.add(this.scmRepository, addedFileSet, commandParameters);
            if (!addResult.isSuccess()) {
                this.logError("add operation failed: %s", addResult.getProviderMessage() + " " + addResult.getCommandOutput());
                throw new MojoExecutionException("Failed to add new files: " + addResult.getProviderMessage() + " " + addResult.getCommandOutput());
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Failed to add new files to SCM", (Exception)((Object)e));
        }
    }

    public boolean isDryRun() {
        return this.dryRun;
    }
}

