/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.scmpublish.AbstractScmPublishMojo;
import org.apache.maven.plugins.scmpublish.ScmPublishInventory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="prepare", defaultPhase=LifecyclePhase.PRE_SITE, aggregator=true)
public class ScmPublishInventoryMojo
extends AbstractScmPublishMojo {
    private void deleteContent(List<File> inventory) {
        for (File f : inventory) {
            if (!f.isFile()) continue;
            FileUtils.deleteQuietly((File)f);
        }
    }

    @Override
    public void scmPublishExecute() throws MojoExecutionException, MojoFailureException {
        this.checkoutExisting();
        List<File> inventory = ScmPublishInventory.listInventoryFiles(this.checkoutDirectory, this.scmProvider.getScmSpecificFilename());
        ScmPublishInventory.writeInventory(inventory, this.inventoryFile);
        this.deleteContent(inventory);
    }
}

