/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.svn.AbstractSvnScmProvider;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public abstract class AbstractScmPublishMojo
extends AbstractMojo {
    @Parameter(property="scmpublish.inventoryFile", defaultValue="${project.build.directory}/scmpublish-inventory.js")
    protected File inventoryFile;
    @Parameter(property="scmpublish.pubScmUrl", defaultValue="${project.distributionManagement.site.url}", required=true)
    protected String pubScmUrl;
    @Parameter(property="scmpublish.checkoutDirectory", defaultValue="${project.build.directory}/scmpublish-checkout")
    protected File checkoutDirectory;
    @Parameter
    protected String excludes;
    @Parameter
    protected String includes;
    @Parameter
    private Map<String, String> providerImplementations;
    @Component
    private ScmManager scmManager;
    @Component
    protected ScmRepositoryConfigurator scmRepositoryConfigurator;
    @Parameter(property="username")
    protected String username;
    @Parameter(property="password")
    protected String password;
    @Parameter(property="localCheckout", defaultValue="false")
    protected boolean localCheckout;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    protected String siteOutputEncoding;
    @Parameter(property="scmpublish.tryUpdate", defaultValue="false")
    protected boolean tryUpdate;
    @Parameter(property="scmpublish.skipDeletedFiles", defaultValue="false")
    protected boolean skipDeletedFiles;
    @Parameter(defaultValue="${basedir}", readonly=true)
    protected File basedir;
    @Component
    protected Settings settings;
    @Component
    protected MavenSession session;
    @Parameter
    protected String[] ignorePathsToDelete;
    @Parameter(property="scmpublish.scm.branch")
    protected String scmBranch;
    @Parameter(property="scmpublish.automaticRemotePathCreation", defaultValue="true")
    protected boolean automaticRemotePathCreation;
    protected ScmProvider scmProvider;
    protected ScmRepository scmRepository;

    protected AbstractScmPublishMojo() {
    }

    protected void logInfo(String format, Object ... params) {
        this.getLog().info((CharSequence)String.format(format, params));
    }

    protected void logError(String format, Object ... params) {
        this.getLog().error((CharSequence)String.format(format, params));
    }

    protected ReleaseDescriptor setupScm() throws ScmRepositoryException, NoSuchScmProviderException {
        if (this.localCheckout) {
            String providerPart = this.pubScmUrl.substring(0, this.pubScmUrl.indexOf(58, 4));
            String scmUrl = providerPart + ":file://" + "target/localCheckout";
            this.logInfo("Performing a LOCAL checkout from " + scmUrl, new Object[0]);
        }
        ReleaseDescriptor releaseDescriptor = new ReleaseDescriptor();
        releaseDescriptor.setInteractive(this.settings.isInteractiveMode());
        releaseDescriptor.setScmPassword(this.password);
        releaseDescriptor.setScmUsername(this.username);
        releaseDescriptor.setWorkingDirectory(this.basedir.getAbsolutePath());
        releaseDescriptor.setLocalCheckout(this.localCheckout);
        releaseDescriptor.setScmSourceUrl(this.pubScmUrl);
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.getLog().info((CharSequence)("Change the default '" + providerEntry.getKey() + "' provider implementation to '" + providerEntry.getValue() + "'."));
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
        this.scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, this.settings);
        this.scmProvider = this.scmRepositoryConfigurator.getRepositoryProvider(this.scmRepository);
        return releaseDescriptor;
    }

    protected void checkoutExisting() throws MojoExecutionException {
        UpdateScmResult scmResult;
        if (this.scmProvider instanceof AbstractSvnScmProvider) {
            File baseDir = null;
            try {
                this.getLog().debug((CharSequence)"use AbstractSvnScmProvider so we can check if remote url exists and create it");
                AbstractSvnScmProvider svnScmProvider = (AbstractSvnScmProvider)this.scmProvider;
                String remoteUrl = ((SvnScmProviderRepository)this.scmRepository.getProviderRepository()).getUrl();
                boolean remoteExists = svnScmProvider.remoteUrlExist(this.scmRepository.getProviderRepository(), null);
                if (!remoteExists) {
                    if (this.automaticRemotePathCreation) {
                        this.logInfo("remote url %s not exists so create it", remoteUrl);
                        baseDir = File.createTempFile("scm", "tmp");
                        baseDir.delete();
                        baseDir.mkdirs();
                        ScmFileSet scmFileSet = new ScmFileSet(baseDir, new File(""));
                        CommandParameters commandParameters = new CommandParameters();
                        commandParameters.setString(CommandParameter.SCM_MKDIR_CREATE_IN_LOCAL, Boolean.FALSE.toString());
                        commandParameters.setString(CommandParameter.MESSAGE, "automatic path creation: " + remoteUrl);
                        svnScmProvider.mkdir(this.scmRepository.getProviderRepository(), scmFileSet, commandParameters);
                        if (this.checkoutDirectory.exists()) {
                            FileUtils.deleteDirectory((File)this.checkoutDirectory);
                        }
                    } else {
                        this.logInfo("remote url %s not exists and not create it as field %s configured to false", remoteUrl, Boolean.toString(this.automaticRemotePathCreation));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (ScmException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            finally {
                if (baseDir != null) {
                    try {
                        FileUtils.forceDeleteOnExit(baseDir);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
            }
        }
        this.logInfo("%s the pub tree from  %s ...", this.tryUpdate ? "Updating" : "Checking out", this.pubScmUrl);
        if (this.checkoutDirectory.exists() && !this.tryUpdate) {
            try {
                FileUtils.deleteDirectory((File)this.checkoutDirectory);
            }
            catch (IOException e) {
                this.logError(e.getMessage(), new Object[0]);
                throw new MojoExecutionException("Unable to remove old checkout directory: " + e.getMessage(), (Exception)e);
            }
        }
        boolean forceCheckout = false;
        if (!this.checkoutDirectory.exists()) {
            if (this.tryUpdate) {
                this.logInfo("tryUpdate is configured but no local copy currently available so forcing checkout", new Object[0]);
            }
            this.checkoutDirectory.mkdirs();
            forceCheckout = true;
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(this.checkoutDirectory, this.includes, this.excludes);
            if (this.tryUpdate && !forceCheckout) {
                scmResult = this.scmProvider.update(this.scmRepository, fileSet);
            } else if (this.scmBranch == null) {
                scmResult = this.scmProvider.checkOut(this.scmRepository, fileSet);
            } else {
                ScmBranch scmBranch = new ScmBranch(this.scmBranch);
                scmResult = this.scmProvider.checkOut(this.scmRepository, fileSet, (ScmVersion)scmBranch);
            }
        }
        catch (ScmException e) {
            this.logError(e.getMessage(), new Object[0]);
            throw new MojoExecutionException("An error is occurred in the checkout process: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.logError(e.getMessage(), new Object[0]);
            throw new MojoExecutionException("An error is occurred in the checkout process: " + e.getMessage(), (Exception)e);
        }
        if (!scmResult.isSuccess()) {
            this.logError(scmResult.getProviderMessage(), new Object[0]);
            throw new MojoExecutionException("Unable to checkout from SCM\nProvider message:\n" + scmResult.getProviderMessage() + "\nCommand output:\n" + scmResult.getCommandOutput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setupScm();
        }
        catch (ScmRepositoryException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (NoSuchScmProviderException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        boolean tmpCheckout = false;
        if (this.checkoutDirectory.getPath().contains("${project.")) {
            try {
                tmpCheckout = true;
                this.checkoutDirectory = File.createTempFile("maven-scm-publish", ".checkout");
                this.checkoutDirectory.delete();
                this.checkoutDirectory.mkdir();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        try {
            this.scmPublishExecute();
        }
        finally {
            if (tmpCheckout) {
                FileUtils.deleteQuietly((File)this.checkoutDirectory);
            }
        }
    }

    public abstract void scmPublishExecute() throws MojoExecutionException, MojoFailureException;
}

