/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang.ClassUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugins.help.HelpUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class EvaluateMojo
extends AbstractMojo {
    private ArtifactFactory artifactFactory;
    private InputHandler inputHandler;
    private MavenProjectBuilder mavenProjectBuilder;
    private PathTranslator pathTranslator;
    private ArtifactResolver resolver;
    private String artifact;
    protected ArtifactRepository localRepository;
    protected MavenProject project;
    private List remoteRepositories;
    protected Settings settings;
    private MavenSession session;
    private PluginParameterExpressionEvaluator evaluator;
    private XStream xstream;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$maven$model$Model;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.settings.isInteractiveMode()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Maven is configured to NOT interact with the user for input. ");
            msg.append("This Mojo requires that 'interactiveMode' in your settings file is flag to 'true'.");
            this.getLog().error((CharSequence)msg.toString());
            return;
        }
        this.validateParameters();
        if (StringUtils.isNotEmpty((String)this.artifact)) {
            Artifact artifactObj = this.getArtifact(this.artifact);
            try {
                this.project = this.getMavenProject(artifactObj);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Unable to get the POM for the artifact '" + this.artifact + "'. Verify the artifact parameter.");
            }
        }
        while (true) {
            this.getLog().info((CharSequence)"Enter the Maven expression i.e. ${project.groupId} or 0 to exit?:");
            try {
                String userExpression = this.inputHandler.readLine();
                if (userExpression == null || userExpression.toLowerCase(Locale.ENGLISH).equals("0")) break;
                this.handleResponse(userExpression);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read from standard input.", (Exception)e);
            }
        }
    }

    private void validateParameters() {
        if (this.artifact == null) {
            this.getLog().info((CharSequence)("No artifact parameter specified, using '" + this.project.getId() + "' as project."));
        }
    }

    private Artifact getArtifact(String artifactString) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)artifactString)) {
            throw new IllegalArgumentException("artifact parameter could not be empty");
        }
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        String[] artifactParts = artifactString.split(":");
        switch (artifactParts.length) {
            case 2: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = "LATEST";
                break;
            }
            case 3: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = artifactParts[2];
                break;
            }
            case 4: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = artifactParts[2];
                classifier = artifactParts[3];
                break;
            }
            default: {
                throw new MojoExecutionException("The artifact parameter '" + artifactString + "' should be conform to: " + "'groupId:artifactId[:version][:classifier]'.");
            }
        }
        if (StringUtils.isNotEmpty(classifier)) {
            return this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, "jar", classifier);
        }
        return this.artifactFactory.createArtifact(groupId, artifactId, version, "compile", "jar");
    }

    private MavenProject getMavenProject(Artifact artifactObj) throws MojoExecutionException, ProjectBuildingException {
        if ("system".equals(artifactObj.getScope())) {
            throw new MojoExecutionException("System artifact is not be handled.");
        }
        Artifact copyArtifact = ArtifactUtils.copyArtifact((Artifact)artifactObj);
        if (!"pom".equals(copyArtifact.getType())) {
            copyArtifact = this.artifactFactory.createProjectArtifact(copyArtifact.getGroupId(), copyArtifact.getArtifactId(), copyArtifact.getVersion(), copyArtifact.getScope());
        }
        return this.mavenProjectBuilder.buildFromRepository(copyArtifact, this.remoteRepositories, this.localRepository);
    }

    private PluginParameterExpressionEvaluator getEvaluator() throws MojoExecutionException, MojoFailureException {
        if (this.evaluator == null) {
            MojoDescriptor mojoDescriptor = HelpUtil.getMojoDescriptor("help:evaluate", this.session, this.project, "help:evaluate", true, false);
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor);
            this.evaluator = new PluginParameterExpressionEvaluator(this.session, mojoExecution, this.pathTranslator, this.session.getContainer().getLogger(), this.project, this.session.getExecutionProperties());
        }
        return this.evaluator;
    }

    private void handleResponse(String expression) throws MojoExecutionException, MojoFailureException {
        Object obj;
        StringBuffer response = new StringBuffer();
        try {
            obj = this.getEvaluator().evaluate(expression);
        }
        catch (ExpressionEvaluationException e) {
            throw new MojoExecutionException("Error when evaluating the Maven expression", (Exception)((Object)e));
        }
        if (obj != null && expression.equals(obj.toString())) {
            this.getLog().warn((CharSequence)"The Maven expression was invalid. Please use a valid expression.");
            return;
        }
        if (obj == null) {
            response.append("null object or invalid expression");
        } else if (obj instanceof String) {
            response.append(obj.toString());
        } else if (obj instanceof Boolean) {
            response.append(obj.toString());
        } else if (obj instanceof Byte) {
            response.append(obj.toString());
        } else if (obj instanceof Character) {
            response.append(obj.toString());
        } else if (obj instanceof Double) {
            response.append(obj.toString());
        } else if (obj instanceof Float) {
            response.append(obj.toString());
        } else if (obj instanceof Integer) {
            response.append(obj.toString());
        } else if (obj instanceof Long) {
            response.append(obj.toString());
        } else if (obj instanceof Short) {
            response.append(obj.toString());
        } else if (obj instanceof File) {
            File f = (File)obj;
            response.append(f.getAbsolutePath());
        } else if (obj instanceof MavenProject) {
            MavenProject projectAsked = (MavenProject)obj;
            StringWriter sWriter = new StringWriter();
            MavenXpp3Writer pomWriter = new MavenXpp3Writer();
            try {
                pomWriter.write((Writer)sWriter, projectAsked.getModel());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error when writing pom", (Exception)e);
            }
            response.append(sWriter.toString());
        } else if (obj instanceof Settings) {
            Settings settingsAsked = (Settings)obj;
            StringWriter sWriter = new StringWriter();
            SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
            try {
                settingsWriter.write((Writer)sWriter, settingsAsked);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error when writing settings", (Exception)e);
            }
            response.append(sWriter.toString());
        } else {
            response.append(this.toXML(expression, obj));
        }
        this.getLog().info((CharSequence)("\n" + response.toString()));
    }

    private String toXML(String expression, Object obj) {
        XStream currentXStream = this.getXStream();
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() > 0) {
                Object elt = list.iterator().next();
                String name = StringUtils.lowercaseFirstLetter((String)ClassUtils.getShortClassName(elt.getClass()));
                currentXStream.alias(EvaluateMojo.pluralize(name), List.class);
            } else if (expression.indexOf(".") != -1) {
                String name = expression.substring(expression.indexOf(".") + 1, expression.indexOf("}"));
                currentXStream.alias(name, List.class);
            }
        }
        return currentXStream.toXML(obj);
    }

    private XStream getXStream() {
        if (this.xstream == null) {
            this.xstream = new XStream();
            this.addAlias(this.xstream);
            this.xstream.registerConverter((Converter)new PropertiesConverter(){

                public boolean canConvert(Class type) {
                    return (class$java$util$Properties == null ? (class$java$util$Properties = EvaluateMojo.class$("java.util.Properties")) : class$java$util$Properties) == type;
                }

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Properties properties = (Properties)source;
                    TreeMap<Object, Object> map = new TreeMap<Object, Object>(properties);
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        writer.startNode(entry.getKey().toString());
                        writer.setValue(entry.getValue().toString());
                        writer.endNode();
                    }
                }
            });
        }
        return this.xstream;
    }

    private void addAlias(XStream xstreamObject) {
        block8: {
            try {
                this.addAlias(xstreamObject, this.getMavenModelJarFile(), "org.apache.maven.model");
                this.addAlias(xstreamObject, this.getMavenSettingsJarFile(), "org.apache.maven.settings");
            }
            catch (MojoExecutionException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("MojoExecutionException: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (ArtifactResolutionException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("ArtifactResolutionException: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (ArtifactNotFoundException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("ArtifactNotFoundException: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (ProjectBuildingException e) {
                if (!this.getLog().isDebugEnabled()) break block8;
                this.getLog().debug((CharSequence)("ProjectBuildingException: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlias(XStream xstreamObject, File jarFile, String packageFilter) {
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null && jarEntry != null) {
                if (jarEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = jarEntry.getName().substring(0, jarEntry.getName().indexOf("."));
                    if ((name = name.replaceAll("/", "\\.")).indexOf(packageFilter) != -1) {
                        try {
                            Class clazz = ClassUtils.getClass((String)name);
                            String alias = StringUtils.lowercaseFirstLetter((String)ClassUtils.getShortClassName((Class)clazz));
                            xstreamObject.alias(alias, clazz);
                            if (!clazz.equals(class$org$apache$maven$model$Model == null ? EvaluateMojo.class$("org.apache.maven.model.Model") : class$org$apache$maven$model$Model)) {
                                xstreamObject.omitField(clazz, "modelEncoding");
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
        }
        catch (IOException e) {
            block10: {
                try {
                    if (!this.getLog().isDebugEnabled()) break block10;
                    this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(jarStream);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)jarStream);
        }
        IOUtil.close((InputStream)jarStream);
    }

    private File getMavenModelJarFile() throws MojoExecutionException, ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.getArtifactFile(true);
    }

    private File getMavenSettingsJarFile() throws MojoExecutionException, ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.getArtifactFile(false);
    }

    private File getArtifactFile(boolean isPom) throws MojoExecutionException, ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        Iterator it = this.getHelpPluginPom().getDependencies().iterator();
        while (it.hasNext()) {
            Dependency depependency = (Dependency)it.next();
            if (!depependency.getGroupId().equals("org.apache.maven") || (isPom ? !depependency.getArtifactId().equals("maven-model") : !depependency.getArtifactId().equals("maven-settings"))) continue;
            Artifact mavenArtifact = this.getArtifact(depependency.getGroupId() + ":" + depependency.getArtifactId() + ":" + depependency.getVersion());
            this.resolver.resolveAlways(mavenArtifact, this.remoteRepositories, this.localRepository);
            return mavenArtifact.getFile();
        }
        throw new MojoExecutionException("Unable to find the 'org.apache.maven:" + (isPom ? "maven-model" : "maven-settings") + "' artifact");
    }

    private MavenProject getHelpPluginPom() throws MojoExecutionException, ProjectBuildingException {
        String resource = "META-INF/maven/org.apache.maven.plugins/maven-help-plugin/pom.properties";
        InputStream resourceAsStream = EvaluateMojo.class.getClassLoader().getResourceAsStream(resource);
        Artifact helpPluginArtifact = null;
        if (resourceAsStream != null) {
            Properties properties;
            block4: {
                properties = new Properties();
                try {
                    properties.load(resourceAsStream);
                }
                catch (IOException e) {
                    if (!this.getLog().isDebugEnabled()) break block4;
                    this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
                }
            }
            String artifactString = properties.getProperty("groupId", "unknown") + ":" + properties.getProperty("artifactId", "unknown") + ":" + properties.getProperty("version", "unknown");
            helpPluginArtifact = this.getArtifact(artifactString);
        }
        if (helpPluginArtifact == null) {
            throw new MojoExecutionException("The help plugin artifact was not found.");
        }
        return this.getMavenProject(helpPluginArtifact);
    }

    private static String pluralize(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name is required");
        }
        if (name.endsWith("y")) {
            return name.substring(0, name.length() - 1) + "ies";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return name + "s";
    }
}

