/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugin.announcement.MailSender;
import org.apache.maven.plugin.announcement.mailsender.ProjectJavamailMailSender;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.codehaus.plexus.util.IOUtil;

public class AnnouncementMailMojo
extends AbstractAnnouncementMojo {
    private List from;
    private String fromDeveloperId;
    private String mailContentType;
    private MailSender mailSender;
    private String senderString;
    private String password;
    private MavenProject project;
    private String smtpHost;
    private int smtpPort;
    private boolean sslMode;
    private String subject;
    private String template;
    private File templateOutputDirectory;
    private List toAddresses;
    private List ccAddresses;
    private List bccAddresses;
    private String username;
    private ProjectJavamailMailSender mailer = new ProjectJavamailMailSender();

    public void execute() throws MojoExecutionException {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement mail in this project because it's not the Execution Root");
        } else {
            File templateFile = new File(this.templateOutputDirectory, this.template);
            ConsoleLogger logger = new ConsoleLogger(1, "base");
            if (this.getLog().isDebugEnabled()) {
                logger.setThreshold(0);
            }
            this.mailer.enableLogging((Logger)logger);
            this.mailer.setSmtpHost(this.getSmtpHost());
            this.mailer.setSmtpPort(this.getSmtpPort());
            this.mailer.setSslMode(this.sslMode);
            if (this.username != null) {
                this.mailer.setUsername(this.username);
            }
            if (this.password != null) {
                this.mailer.setPassword(this.password);
            }
            this.mailer.initialize();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("fromDeveloperId: " + this.getFromDeveloperId()));
            }
            if (templateFile.isFile()) {
                this.getLog().info((CharSequence)("Connecting to Host: " + this.getSmtpHost() + ":" + this.getSmtpPort()));
                this.sendMessage();
            } else {
                throw new MojoExecutionException("Announcement template " + templateFile + " not found...");
            }
        }
    }

    protected void sendMessage() throws MojoExecutionException {
        File templateFile = new File(this.templateOutputDirectory, this.template);
        String email = "";
        MailSender ms = this.getActualMailSender();
        String fromName = ms.getName();
        String fromAddress = ms.getEmail();
        if (fromAddress == null || fromAddress.equals("")) {
            throw new MojoExecutionException("Invalid mail sender: name and email is mandatory (" + ms + ").");
        }
        this.getLog().info((CharSequence)("Using this sender for email announcement: " + fromAddress + " < " + fromName + " > "));
        try {
            MailMessage mailMsg = new MailMessage();
            mailMsg.setSubject(this.getSubject());
            mailMsg.setContent(IOUtil.toString((Reader)this.readAnnouncement(templateFile)));
            mailMsg.setContentType(this.mailContentType);
            mailMsg.setFrom(fromAddress, fromName);
            Iterator it = this.getToAddresses().iterator();
            while (it.hasNext()) {
                email = it.next().toString();
                this.getLog().info((CharSequence)("Sending mail to " + email + "..."));
                mailMsg.addTo(email, "");
            }
            if (this.getCcAddresses() != null) {
                Iterator it2 = this.getCcAddresses().iterator();
                while (it2.hasNext()) {
                    email = it2.next().toString();
                    this.getLog().info((CharSequence)("Sending cc mail to " + email + "..."));
                    mailMsg.addCc(email, "");
                }
            }
            if (this.getBccAddresses() != null) {
                Iterator it3 = this.getBccAddresses().iterator();
                while (it3.hasNext()) {
                    email = it3.next().toString();
                    this.getLog().info((CharSequence)("Sending bcc mail to " + email + "..."));
                    mailMsg.addBcc(email, "");
                }
            }
            this.mailer.send(mailMsg);
            this.getLog().info((CharSequence)"Sent...");
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to send email.", (Exception)ioe);
        }
        catch (MailSenderException e) {
            throw new MojoExecutionException("Failed to send email < " + email + " >", (Exception)((Object)e));
        }
    }

    protected FileReader readAnnouncement(File file) throws MojoExecutionException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("File not found. " + file);
        }
        return fileReader;
    }

    protected MailSender getActualMailSender() throws MojoExecutionException {
        if (this.senderString != null) {
            try {
                InternetAddress ia = new InternetAddress(this.senderString, true);
                return new MailSender(ia.getPersonal(), ia.getAddress());
            }
            catch (AddressException e) {
                throw new MojoExecutionException("Invalid value for change.sender: ", (Exception)((Object)e));
            }
        }
        if (this.mailSender != null && this.mailSender.getEmail() != null) {
            return this.mailSender;
        }
        if (this.from == null || this.from.isEmpty()) {
            throw new MojoExecutionException("The <developers> section in your pom should not be empty. Add a <developer> entry or set the mailSender parameter.");
        }
        if (this.fromDeveloperId == null) {
            Developer dev = (Developer)this.from.get(0);
            return new MailSender(dev.getName(), dev.getEmail());
        }
        for (Developer developer : this.from) {
            if (!this.fromDeveloperId.equals(developer.getId())) continue;
            return new MailSender(developer.getName(), developer.getEmail());
        }
        throw new MojoExecutionException("Missing developer with id '" + this.fromDeveloperId + "' in the <developers> section in your pom.");
    }

    public List getBccAddresses() {
        return this.bccAddresses;
    }

    public void setBccAddresses(List bccAddresses) {
        this.bccAddresses = bccAddresses;
    }

    public List getCcAddresses() {
        return this.ccAddresses;
    }

    public void setCcAddresses(List ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    public List getFrom() {
        return this.from;
    }

    public void setFrom(List from) {
        this.from = from;
    }

    public String getFromDeveloperId() {
        return this.fromDeveloperId;
    }

    public void setFromDeveloperId(String fromDeveloperId) {
        this.fromDeveloperId = fromDeveloperId;
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isSslMode() {
        return this.sslMode;
    }

    public void setSslMode(boolean sslMode) {
        this.sslMode = sslMode;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public File getTemplateOutputDirectory() {
        return this.templateOutputDirectory;
    }

    public void setTemplateOutputDirectory(File templateOutputDirectory) {
        this.templateOutputDirectory = templateOutputDirectory;
    }

    public List getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

