/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

public class IssueAdapter {
    public static List getReleases(List issues) {
        HashMap<String, Release> releasesMap = new HashMap<String, Release>();
        for (int i = 0; i < issues.size(); ++i) {
            Issue issue = (Issue)issues.get(i);
            if (issue.getFixVersions() == null) continue;
            Iterator iterator = issue.getFixVersions().iterator();
            while (iterator.hasNext()) {
                String fixVersion = (String)iterator.next();
                Release release = (Release)releasesMap.get(fixVersion);
                if (release == null) {
                    release = new Release();
                    release.setVersion(fixVersion);
                    releasesMap.put(fixVersion, release);
                }
                Action action = IssueAdapter.createAction(issue);
                release.addAction(action);
            }
        }
        ArrayList<Release> releasesList = new ArrayList<Release>();
        Iterator iterator = releasesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Release o = (Release)iterator.next().getValue();
            releasesList.add(o);
        }
        return releasesList;
    }

    public static Action createAction(Issue issue) {
        Action action = new Action();
        action.setIssue(issue.getKey());
        String type = "";
        if (issue.getType().equals("Bug")) {
            type = "fix";
        } else if (issue.getType().equals("New Feature")) {
            type = "add";
        } else if (issue.getType().equals("Improvement")) {
            type = "update";
        }
        action.setType(type);
        action.setDev(issue.getAssignee());
        action.setDueTo("");
        action.setAction(issue.getSummary());
        return action;
    }
}

