/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.logging.Log;

public class JiraHelper {
    private static final String PID = "pid=";

    public static String getPidFromJira(Log log, String issueManagementUrl, HttpClient client) {
        String projectPage;
        String jiraId = null;
        GetMethod gm = new GetMethod(issueManagementUrl);
        try {
            client.executeMethod((HttpMethod)gm);
            log.debug((CharSequence)"Successfully reached JIRA.");
            projectPage = gm.getResponseBodyAsString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((CharSequence)"Unable to reach the JIRA project page:", (Throwable)e);
            } else {
                log.error((CharSequence)("Unable to reach the JIRA project page. Cause is: " + e.getLocalizedMessage()));
            }
            return null;
        }
        int pidIndex = projectPage.indexOf(PID);
        if (pidIndex == -1) {
            log.error((CharSequence)("Unable to extract a JIRA pid from the page at the url " + issueManagementUrl));
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            Number pidNumber = nf.parse(projectPage, new ParsePosition(pidIndex + PID.length()));
            jiraId = Integer.toString(pidNumber.intValue());
            log.debug((CharSequence)("Found the pid " + jiraId + " at " + issueManagementUrl));
        }
        return jiraId;
    }
}

