/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class ThreadLocalDigest {
    public static MessageDigest get(ThreadLocal<MessageDigest> local, String algorithm) {
        MessageDigest digest = local.get();
        if (digest == null) {
            return ThreadLocalDigest.create(local, algorithm);
        }
        if (Objects.equals(digest.getAlgorithm(), algorithm)) {
            return ThreadLocalDigest.reset(digest);
        }
        ThreadLocalDigest.reset(digest);
        return ThreadLocalDigest.create(local, algorithm);
    }

    private static MessageDigest create(ThreadLocal<MessageDigest> local, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            local.set(digest);
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create message digest with algorithm: " + algorithm, e);
        }
    }

    private static MessageDigest reset(MessageDigest digest) {
        digest.reset();
        return digest;
    }

    private ThreadLocalDigest() {
    }
}

