/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.StrDocValues;
import org.apache.lucene.queries.function.valuesource.DocValuesFieldSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.PackedInts;

public class StrDocValuesFieldSource
extends DocValuesFieldSource {
    public StrDocValuesFieldSource(String fieldName, boolean direct) {
        super(fieldName, direct);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        DocValues.Source source = this.getSource(readerContext.reader(), DocValues.Type.BYTES_VAR_SORTED);
        Bits liveDocs = readerContext.reader().getLiveDocs();
        switch (source.getType()) {
            case BYTES_FIXED_DEREF: 
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_VAR_DEREF: 
            case BYTES_VAR_STRAIGHT: {
                return new DVStrValues(this, source, liveDocs);
            }
            case BYTES_FIXED_SORTED: 
            case BYTES_VAR_SORTED: {
                final DocValues.SortedSource sortedSource = source.asSortedSource();
                if (sortedSource.hasPackedDocToOrd()) {
                    final PackedInts.Reader docToOrd = sortedSource.getDocToOrd();
                    return new DVStrValues(this, source, liveDocs){

                        @Override
                        public int ordVal(int doc) {
                            return (int)docToOrd.get(doc);
                        }

                        @Override
                        public int numOrd() {
                            return sortedSource.getValueCount();
                        }
                    };
                }
                return new DVStrValues(this, source, liveDocs){

                    @Override
                    public int ordVal(int doc) {
                        return sortedSource.ord(doc);
                    }

                    @Override
                    public int numOrd() {
                        return sortedSource.getValueCount();
                    }
                };
            }
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " only works with binary types, not " + source.getType());
    }

    private static class DVStrValues
    extends StrDocValues {
        private final Bits liveDocs;
        private final DocValues.Source source;

        public DVStrValues(ValueSource vs, DocValues.Source source, Bits liveDocs) {
            super(vs);
            this.liveDocs = liveDocs;
            this.source = source;
        }

        @Override
        public boolean exists(int doc) {
            return this.liveDocs == null || this.liveDocs.get(doc);
        }

        @Override
        public boolean bytesVal(int doc, BytesRef target) {
            this.source.getBytes(doc, target);
            return true;
        }

        @Override
        public String strVal(int doc) {
            BytesRef utf8Bytes = new BytesRef();
            this.source.getBytes(doc, utf8Bytes);
            return utf8Bytes.utf8ToString();
        }
    }
}

