/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.util.OrdinalMappingAtomicReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;

public class TaxonomyMergeUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Directory srcIndexDir, Directory srcTaxDir, DirectoryTaxonomyWriter.OrdinalMap map, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxWriter, FacetIndexingParams params) throws IOException {
        destTaxWriter.addTaxonomy(srcTaxDir, map);
        int[] ordinalMap = map.getMap();
        DirectoryReader reader = DirectoryReader.open((Directory)srcIndexDir, (int)-1);
        List leaves = reader.leaves();
        int numReaders = leaves.size();
        AtomicReader[] wrappedLeaves = new AtomicReader[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            wrappedLeaves[i] = new OrdinalMappingAtomicReader(((AtomicReaderContext)leaves.get(i)).reader(), ordinalMap, params);
        }
        try {
            destIndexWriter.addIndexes(new IndexReader[]{new MultiReader((IndexReader[])wrappedLeaves)});
            destTaxWriter.commit();
            destIndexWriter.commit();
        }
        finally {
            reader.close();
        }
    }
}

