/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.old;

import java.io.IOException;
import org.apache.lucene.facet.old.Aggregator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.IntsRef;

public class ScoringAggregator
implements Aggregator {
    private final float[] scoreArray;
    private final int hashCode;

    public ScoringAggregator(float[] counterArray) {
        this.scoreArray = counterArray;
        this.hashCode = this.scoreArray == null ? 0 : this.scoreArray.hashCode();
    }

    @Override
    public void aggregate(int docID, float score, IntsRef ordinals) throws IOException {
        for (int i = 0; i < ordinals.length; ++i) {
            int n = ordinals.ints[i];
            this.scoreArray[n] = this.scoreArray[n] + score;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ScoringAggregator that = (ScoringAggregator)obj;
        return that.scoreArray == this.scoreArray;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        return true;
    }
}

