/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.IntsRef;

public class MultiCategoryListIterator
implements CategoryListIterator {
    private final CategoryListIterator[] iterators;
    private final List<CategoryListIterator> validIterators;

    public MultiCategoryListIterator(CategoryListIterator ... iterators) {
        this.iterators = iterators;
        this.validIterators = new ArrayList<CategoryListIterator>();
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        this.validIterators.clear();
        for (CategoryListIterator cli : this.iterators) {
            if (!cli.setNextReader(context)) continue;
            this.validIterators.add(cli);
        }
        return !this.validIterators.isEmpty();
    }

    @Override
    public void getOrdinals(int docID, IntsRef ints) throws IOException {
        IntsRef tmp = new IntsRef(ints.length);
        for (CategoryListIterator cli : this.validIterators) {
            cli.getOrdinals(docID, tmp);
            if (ints.ints.length < ints.length + tmp.length) {
                ints.grow(ints.length + tmp.length);
            }
            ints.length += tmp.length;
        }
    }
}

