/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.collections.LRUHashMap;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.ParallelTaxonomyArrays;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class DirectoryTaxonomyReader
extends TaxonomyReader {
    private static final Logger logger = Logger.getLogger(DirectoryTaxonomyReader.class.getName());
    private static final int DEFAULT_CACHE_VALUE = 4000;
    private final DirectoryTaxonomyWriter taxoWriter;
    private final long taxoEpoch;
    private final DirectoryReader indexReader;
    private LRUHashMap<CategoryPath, Integer> ordinalCache;
    private LRUHashMap<Integer, CategoryPath> categoryCache;
    private volatile ParallelTaxonomyArrays taxoArrays;
    private char delimiter = (char)31;

    DirectoryTaxonomyReader(DirectoryReader indexReader, DirectoryTaxonomyWriter taxoWriter, LRUHashMap<CategoryPath, Integer> ordinalCache, LRUHashMap<Integer, CategoryPath> categoryCache, ParallelTaxonomyArrays taxoArrays) throws IOException {
        this.indexReader = indexReader;
        this.taxoWriter = taxoWriter;
        this.taxoEpoch = taxoWriter == null ? -1L : taxoWriter.getTaxonomyEpoch();
        this.ordinalCache = ordinalCache == null ? new LRUHashMap(4000) : ordinalCache;
        this.categoryCache = categoryCache == null ? new LRUHashMap(4000) : categoryCache;
        this.taxoArrays = taxoArrays != null ? new ParallelTaxonomyArrays((IndexReader)indexReader, taxoArrays) : null;
    }

    public DirectoryTaxonomyReader(Directory directory) throws IOException {
        this.indexReader = this.openIndexReader(directory);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
        this.ordinalCache = new LRUHashMap(4000);
        this.categoryCache = new LRUHashMap(4000);
    }

    public DirectoryTaxonomyReader(DirectoryTaxonomyWriter taxoWriter) throws IOException {
        this.taxoWriter = taxoWriter;
        this.taxoEpoch = taxoWriter.getTaxonomyEpoch();
        this.indexReader = this.openIndexReader(taxoWriter.getInternalIndexWriter());
        this.ordinalCache = new LRUHashMap(4000);
        this.categoryCache = new LRUHashMap(4000);
    }

    private synchronized void initTaxoArrays() throws IOException {
        if (this.taxoArrays == null) {
            ParallelTaxonomyArrays tmpArrays;
            this.taxoArrays = tmpArrays = new ParallelTaxonomyArrays((IndexReader)this.indexReader);
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.indexReader.close();
        this.taxoArrays = null;
        this.ordinalCache = null;
        this.categoryCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DirectoryTaxonomyReader doOpenIfChanged() throws IOException {
        DirectoryTaxonomyReader directoryTaxonomyReader;
        block11: {
            this.ensureOpen();
            DirectoryReader r2 = this.taxoWriter == null ? DirectoryReader.openIfChanged((DirectoryReader)this.indexReader) : DirectoryReader.openIfChanged((DirectoryReader)this.indexReader, (IndexWriter)this.taxoWriter.getInternalIndexWriter(), (boolean)false);
            if (r2 == null) {
                return null;
            }
            boolean success = false;
            try {
                boolean recreated = false;
                if (this.taxoWriter == null) {
                    String t1 = (String)this.indexReader.getIndexCommit().getUserData().get("index.epoch");
                    String t2 = (String)r2.getIndexCommit().getUserData().get("index.epoch");
                    if (t1 == null) {
                        if (t2 != null) {
                            recreated = true;
                        }
                    } else if (!t1.equals(t2)) {
                        recreated = true;
                    }
                } else if (this.taxoEpoch != this.taxoWriter.getTaxonomyEpoch()) {
                    recreated = true;
                }
                DirectoryTaxonomyReader newtr = recreated ? new DirectoryTaxonomyReader(r2, this.taxoWriter, null, null, null) : new DirectoryTaxonomyReader(r2, this.taxoWriter, this.ordinalCache, this.categoryCache, this.taxoArrays);
                success = true;
                directoryTaxonomyReader = newtr;
                if (success) break block11;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r2});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r2});
        }
        return directoryTaxonomyReader;
    }

    protected DirectoryReader openIndexReader(Directory directory) throws IOException {
        return DirectoryReader.open((Directory)directory);
    }

    protected DirectoryReader openIndexReader(IndexWriter writer) throws IOException {
        return DirectoryReader.open((IndexWriter)writer, (boolean)false);
    }

    DirectoryReader getInternalIndexReader() {
        this.ensureOpen();
        return this.indexReader;
    }

    @Override
    public ParallelTaxonomyArrays getParallelTaxonomyArrays() throws IOException {
        this.ensureOpen();
        if (this.taxoArrays == null) {
            this.initTaxoArrays();
        }
        return this.taxoArrays;
    }

    @Override
    public Map<String, String> getCommitUserData() throws IOException {
        this.ensureOpen();
        return this.indexReader.getIndexCommit().getUserData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrdinal(CategoryPath cp) throws IOException {
        this.ensureOpen();
        if (cp.length == 0) {
            return 0;
        }
        LRUHashMap<CategoryPath, Integer> lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            Integer res = (Integer)this.ordinalCache.get(cp);
            if (res != null) {
                if (res < this.indexReader.maxDoc()) {
                    return res;
                }
                return -1;
            }
        }
        int ret = -1;
        DocsEnum docs = MultiFields.getTermDocsEnum((IndexReader)this.indexReader, null, (String)"$full_path$", (BytesRef)new BytesRef((CharSequence)cp.toString(this.delimiter)), (int)0);
        if (docs != null && docs.nextDoc() != Integer.MAX_VALUE) {
            ret = docs.docID();
            LRUHashMap<CategoryPath, Integer> lRUHashMap2 = this.ordinalCache;
            synchronized (lRUHashMap2) {
                this.ordinalCache.put(cp, ret);
            }
        }
        return ret;
    }

    @Override
    public int getParent(int ordinal) throws IOException {
        this.ensureOpen();
        return this.getParallelTaxonomyArrays().parents()[ordinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryPath getPath(int ordinal) throws IOException {
        this.ensureOpen();
        if (ordinal < 0 || ordinal >= this.indexReader.maxDoc()) {
            return null;
        }
        Integer catIDInteger = ordinal;
        LRUHashMap<Integer, CategoryPath> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            CategoryPath res = (CategoryPath)this.categoryCache.get(catIDInteger);
            if (res != null) {
                return res;
            }
        }
        Document doc = this.indexReader.document(ordinal);
        CategoryPath ret = new CategoryPath(doc.get("$full_path$"), this.delimiter);
        LRUHashMap<Integer, CategoryPath> lRUHashMap2 = this.categoryCache;
        synchronized (lRUHashMap2) {
            this.categoryCache.put(catIDInteger, ret);
        }
        return ret;
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.indexReader.numDocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        this.ensureOpen();
        LRUHashMap<Comparable<Integer>, Comparable<CategoryPath>> lRUHashMap = this.categoryCache;
        synchronized (lRUHashMap) {
            this.categoryCache.setMaxSize(size);
        }
        lRUHashMap = this.ordinalCache;
        synchronized (lRUHashMap) {
            this.ordinalCache.setMaxSize(size);
        }
    }

    public void setDelimiter(char delimiter) {
        this.ensureOpen();
        this.delimiter = delimiter;
    }

    public String toString(int max) {
        this.ensureOpen();
        StringBuilder sb = new StringBuilder();
        int upperl = Math.min(max, this.indexReader.maxDoc());
        for (int i = 0; i < upperl; ++i) {
            try {
                CategoryPath category = this.getPath(i);
                if (category == null) {
                    sb.append(i + ": NULL!! \n");
                    continue;
                }
                if (category.length == 0) {
                    sb.append(i + ": EMPTY STRING!! \n");
                    continue;
                }
                sb.append(i + ": " + category.toString() + "\n");
                continue;
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return sb.toString();
    }
}

