/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class OrdinalsCache {
    private static final Map<BinaryDocValues, CachedOrds> intsCache = new WeakHashMap<BinaryDocValues, CachedOrds>();

    public static synchronized CachedOrds getCachedOrds(AtomicReaderContext context, CategoryListParams clp) throws IOException {
        BinaryDocValues dv = context.reader().getBinaryDocValues(clp.field);
        if (dv == null) {
            return null;
        }
        CachedOrds ci = intsCache.get(dv);
        if (ci == null) {
            ci = new CachedOrds(dv, context.reader().maxDoc(), clp);
            intsCache.put(dv, ci);
        }
        return ci;
    }

    public static final class CachedOrds {
        public final int[] offsets;
        public final int[] ordinals;

        public CachedOrds(BinaryDocValues dv, int maxDoc, CategoryListParams clp) {
            BytesRef buf = new BytesRef();
            this.offsets = new int[maxDoc + 1];
            int[] ords = new int[maxDoc];
            int totOrds = 0;
            IntDecoder decoder = clp.createEncoder().createMatchingDecoder();
            IntsRef values = new IntsRef(32);
            for (int docID = 0; docID < maxDoc; ++docID) {
                this.offsets[docID] = totOrds;
                dv.get(docID, buf);
                if (buf.length <= 0) continue;
                decoder.decode(buf, values);
                if (totOrds + values.length >= ords.length) {
                    ords = ArrayUtil.grow((int[])ords, (int)(totOrds + values.length + 1));
                }
                for (int i = 0; i < values.length; ++i) {
                    ords[totOrds++] = values.ints[i];
                }
            }
            this.offsets[maxDoc] = totOrds;
            if ((double)totOrds / (double)ords.length < 0.9) {
                this.ordinals = new int[totOrds];
                System.arraycopy(ords, 0, this.ordinals, 0, totOrds);
            } else {
                this.ordinals = ords;
            }
        }
    }
}

