/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.encoding;

import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public final class DGapIntDecoder
extends IntDecoder {
    private final IntDecoder decoder;

    public DGapIntDecoder(IntDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public void decode(BytesRef buf, IntsRef values) {
        this.decoder.decode(buf, values);
        int prev = 0;
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            values.ints[n] = values.ints[n] + prev;
            prev = values.ints[i];
        }
    }

    public String toString() {
        return "DGap(" + this.decoder.toString() + ")";
    }
}

