/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.ScoredDocIdCollector;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetsCollector
extends Collector {
    protected final FacetsAccumulator facetsAccumulator;
    private ScoredDocIdCollector scoreDocIdCollector;
    private List<FacetResult> results;
    private Object resultsGuard;

    public FacetsCollector(FacetSearchParams facetSearchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this.facetsAccumulator = this.initFacetsAccumulator(facetSearchParams, indexReader, taxonomyReader);
        this.scoreDocIdCollector = this.initScoredDocCollector(facetSearchParams, indexReader, taxonomyReader);
        this.resultsGuard = new Object();
    }

    protected ScoredDocIdCollector initScoredDocCollector(FacetSearchParams facetSearchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        boolean scoresNeeded = false;
        for (FacetRequest frq : facetSearchParams.getFacetRequests()) {
            if (!frq.requireDocumentScore()) continue;
            scoresNeeded = true;
            break;
        }
        return ScoredDocIdCollector.create(indexReader.maxDoc(), scoresNeeded);
    }

    protected FacetsAccumulator initFacetsAccumulator(FacetSearchParams facetSearchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        return new StandardFacetsAccumulator(facetSearchParams, indexReader, taxonomyReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FacetResult> getFacetResults() throws IOException {
        Object object = this.resultsGuard;
        synchronized (object) {
            if (this.results == null) {
                this.results = this.facetsAccumulator.accumulate(this.scoreDocIdCollector.getScoredDocIDs());
                this.scoreDocIdCollector = null;
            }
            return this.results;
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public void collect(int doc) throws IOException {
        this.scoreDocIdCollector.collect(doc);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.scoreDocIdCollector.setNextReader(reader, docBase);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scoreDocIdCollector.setScorer(scorer);
    }
}

