// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: src/java/org/apache/lucene/analysis/wikipedia/WikipediaTokenizerImpl.jflex

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.analysis.wikipedia;

import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

/** JFlex-generated tokenizer that is aware of Wikipedia syntax. */

// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings({"fallthrough", "unused"})
class WikipediaTokenizerImpl {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 4096;

  /** Lexical states. */
  public static final int YYINITIAL = 0;

  public static final int CATEGORY_STATE = 2;
  public static final int INTERNAL_LINK_STATE = 4;
  public static final int EXTERNAL_LINK_STATE = 6;
  public static final int TWO_SINGLE_QUOTES_STATE = 8;
  public static final int THREE_SINGLE_QUOTES_STATE = 10;
  public static final int FIVE_SINGLE_QUOTES_STATE = 12;
  public static final int DOUBLE_EQUALS_STATE = 14;
  public static final int DOUBLE_BRACE_STATE = 16;
  public static final int STRING = 18;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l ZZ_LEXSTATE[l+1] is the state in
   * the DFA for the lexical state l at the beginning of a line l is of the form l = 2*k, k a non
   * negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
    0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9
  };

  /** Top-level table for translating characters to character classes */
  private static final int[] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
      "\1\0\5\u0100\1\u0200\2\u0100\2\u0300\1\u0400\1\u0300\1\u0500"
          + "\1\u0600\1\u0100\1\u0700\1\u0800\16\u0100\20\u0900\1\u0a00\1\u0b00"
          + "\1\u0900\1\u0c00\31\u0d00\1\u0e00\122\u0d00\14\u0900\53\u0f00\1\u1000"
          + "\41\u0900\2\u0d00\4\u0900\1\u1100\u1000\u0900";

  private static int[] zzUnpackcmap_top() {
    int[] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value;
      while (--count > 0);
    }
    return j;
  }

  /** Second-level tables for translating characters to character classes */
  private static final int[] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
      "\11\0\1\1\1\2\1\0\1\1\1\3\22\0\1\1"
          + "\1\0\1\4\1\5\2\0\1\6\1\7\4\0\1\10"
          + "\1\11\1\12\1\13\12\14\1\15\1\0\1\16\1\17"
          + "\1\20\1\5\1\21\2\22\1\23\5\22\1\24\21\22"
          + "\1\25\1\0\1\26\1\0\1\27\1\0\1\30\1\31"
          + "\2\22\1\32\1\33\1\34\1\35\1\24\4\22\1\36"
          + "\1\37\1\40\1\22\1\41\1\42\1\43\3\22\1\44"
          + "\1\45\1\22\1\46\1\47\1\50\102\0\27\22\1\0"
          + "\37\22\1\0\u0168\22\12\51\206\22\12\51\154\22\12\51"
          + "\166\22\12\51\166\22\12\51\167\22\11\51\166\22\12\51"
          + "\340\22\12\51\166\22\12\51\146\22\12\51\u01b6\22\u0140\0"
          + "\u0150\52\140\0\220\52\200\0\u01c0\52\100\0\u01b0\53\265\0"
          + "\73\52\75\22\43\0";

  private static int[] zzUnpackcmap_blocks() {
    int[] result = new int[4608];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value;
      while (--count > 0);
    }
    return j;
  }

  /** Translates DFA states to action switch labels. */
  private static final int[] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
      "\12\0\2\1\1\2\2\1\1\2\1\3\1\1\1\2"
          + "\1\4\1\2\1\5\1\6\2\5\1\7\1\5\1\10"
          + "\1\5\1\11\1\10\1\12\1\11\1\13\1\14\1\15"
          + "\1\16\1\15\1\17\1\20\1\21\2\10\2\22\1\23"
          + "\2\22\1\24\1\25\1\26\7\0\1\27\6\0\1\30"
          + "\1\31\2\0\1\32\1\33\1\11\1\0\1\34\1\35"
          + "\1\36\1\0\1\37\1\0\1\40\11\41\4\0\1\42"
          + "\1\43\2\41\2\0\1\41\1\44\1\41\1\44\1\42"
          + "\3\0\2\41\1\44\1\11\1\45\3\0\1\46\1\47"
          + "\12\0\2\50\3\0\2\50\1\11\4\0\1\51\1\0"
          + "\1\31\1\44\1\41\3\0\1\11\2\0\1\52\30\0"
          + "\1\53\2\0\1\54\1\55\1\56";

  private static int[] zzUnpackAction() {
    int[] result = new int[181];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value;
      while (--count > 0);
    }
    return j;
  }

  /** Translates a state to a row index in the transition table */
  private static final int[] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
      "\0\0\0\54\0\130\0\204\0\260\0\334\0\u0108\0\u0134"
          + "\0\u0160\0\u018c\0\u01b8\0\u01e4\0\u0210\0\u023c\0\u0268\0\u0294"
          + "\0\u02c0\0\u02ec\0\u0318\0\u01b8\0\u0344\0\u01b8\0\u0370\0\u039c"
          + "\0\u03c8\0\u03f4\0\u0420\0\u01b8\0\u044c\0\u0478\0\u039c\0\u01b8"
          + "\0\u04a4\0\u04d0\0\u04fc\0\u0528\0\u0554\0\u0580\0\u05ac\0\u05d8"
          + "\0\u0604\0\u0630\0\u065c\0\u01b8\0\u0688\0\u06b4\0\u039c\0\u06e0"
          + "\0\u070c\0\u01b8\0\u01b8\0\u0738\0\u0764\0\u0790\0\u07bc\0\u07e8"
          + "\0\u0814\0\u0840\0\u01b8\0\u086c\0\u0898\0\u08c4\0\u08f0\0\u091c"
          + "\0\u0948\0\u0974\0\u09a0\0\u09cc\0\u09f8\0\u01b8\0\u01b8\0\u0a24"
          + "\0\u0a50\0\u0a7c\0\u0a7c\0\u01b8\0\u0aa8\0\u0ad4\0\u0b00\0\u0b2c"
          + "\0\u0b58\0\u0b84\0\u0bb0\0\u0bdc\0\u0c08\0\u0c34\0\u0c60\0\u0c8c"
          + "\0\u0cb8\0\u0ce4\0\u0d10\0\u0d3c\0\u0d68\0\u086c\0\u0d94\0\u0dc0"
          + "\0\u0dec\0\u0e18\0\u0e44\0\u0e70\0\u0e9c\0\u0ec8\0\u0ef4\0\u0f20"
          + "\0\u0f4c\0\u0f78\0\u0fa4\0\u0fd0\0\u0ffc\0\u1028\0\u1054\0\u01b8"
          + "\0\u1080\0\u10ac\0\u10d8\0\u1104\0\u01b8\0\u1130\0\u115c\0\u1188"
          + "\0\u11b4\0\u11e0\0\u120c\0\u1238\0\u1264\0\u1290\0\u12bc\0\u12e8"
          + "\0\u1314\0\u1340\0\u136c\0\u1398\0\u091c\0\u09cc\0\u13c4\0\u13f0"
          + "\0\u141c\0\u1448\0\u1474\0\u14a0\0\u14cc\0\u01b8\0\u14f8\0\u1524"
          + "\0\u1550\0\u157c\0\u15a8\0\u15d4\0\u1600\0\u162c\0\u01b8\0\u1658"
          + "\0\u1684\0\u16b0\0\u16dc\0\u1708\0\u1734\0\u1760\0\u178c\0\u17b8"
          + "\0\u17e4\0\u1810\0\u183c\0\u1868\0\u1894\0\u18c0\0\u18ec\0\u1918"
          + "\0\u1944\0\u1970\0\u199c\0\u19c8\0\u19f4\0\u1a20\0\u1a4c\0\u1a78"
          + "\0\u1aa4\0\u1ad0\0\u01b8\0\u01b8\0\u01b8";

  private static int[] zzUnpackRowMap() {
    int[] result = new int[181];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** The transition table of the DFA */
  private static final int[] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
      "\7\13\1\14\4\13\1\15\1\13\1\16\1\17\2\13"
          + "\3\20\1\21\2\13\16\20\1\22\2\13\1\23\1\24"
          + "\1\25\14\26\1\27\1\26\1\30\3\26\3\27\1\26"
          + "\1\31\1\26\16\27\3\26\1\27\1\26\1\27\14\26"
          + "\1\32\1\26\1\30\3\26\3\32\1\26\1\33\1\26"
          + "\16\32\3\26\1\32\1\26\1\32\1\34\2\26\1\35"
          + "\10\34\1\36\1\34\1\37\3\34\3\36\1\34\1\40"
          + "\1\34\5\36\1\41\10\36\3\34\1\36\1\34\1\36"
          + "\7\34\1\42\4\34\1\43\1\34\1\37\3\34\3\43"
          + "\1\44\2\34\16\43\3\34\1\43\1\34\1\43\14\34"
          + "\1\45\1\34\1\37\3\34\3\45\1\44\2\34\16\45"
          + "\3\34\1\45\1\34\1\45\14\34\1\45\1\34\1\37"
          + "\3\34\3\45\1\46\2\34\16\45\3\34\1\45\1\34"
          + "\1\45\14\34\1\47\1\34\1\37\1\50\2\34\3\47"
          + "\3\34\16\47\3\34\1\47\1\34\1\47\14\34\1\51"
          + "\1\34\1\52\3\34\3\51\3\34\16\51\2\34\1\53"
          + "\1\51\1\34\1\51\7\54\1\55\4\54\1\56\1\54"
          + "\1\57\1\60\2\54\3\56\1\61\2\54\16\56\1\54"
          + "\1\62\1\54\1\56\1\54\1\56\63\0\1\63\54\0"
          + "\1\64\1\65\1\66\1\64\1\15\4\0\1\67\3\15"
          + "\2\0\1\65\16\15\3\0\1\15\1\0\1\25\13\0"
          + "\1\70\1\71\5\0\3\71\3\0\11\71\1\72\4\71"
          + "\3\0\1\71\1\0\1\71\17\0\1\73\42\0\1\74"
          + "\1\75\1\76\1\77\1\100\1\76\1\15\4\0\1\101"
          + "\3\20\2\0\1\77\16\20\3\0\1\23\1\0\1\25"
          + "\25\0\1\102\74\0\1\103\13\0\1\74\1\75\1\64"
          + "\1\65\1\104\1\64\1\15\4\0\1\101\3\23\2\0"
          + "\1\65\16\23\3\0\1\23\1\0\1\25\10\0\1\76"
          + "\1\77\1\105\1\76\1\25\4\0\1\67\3\25\2\0"
          + "\1\77\16\25\3\0\1\25\1\0\1\25\14\0\1\27"
          + "\5\0\3\27\3\0\16\27\3\0\1\27\1\0\1\27"
          + "\13\0\1\70\1\71\5\0\3\71\3\0\16\71\3\0"
          + "\1\71\1\0\1\71\26\0\1\106\41\0\1\32\5\0"
          + "\3\32\3\0\16\32\3\0\1\32\1\0\1\32\26\0"
          + "\1\107\27\0\1\26\65\0\1\36\5\0\3\36\3\0"
          + "\16\36\3\0\1\36\1\0\1\36\14\0\1\36\5\0"
          + "\3\36\3\0\13\36\1\110\2\36\3\0\1\36\1\0"
          + "\1\36\7\0\1\111\60\0\1\43\5\0\3\43\3\0"
          + "\16\43\3\0\1\43\1\0\1\43\25\0\1\112\42\0"
          + "\1\45\5\0\3\45\3\0\16\45\3\0\1\45\1\0"
          + "\1\45\25\0\1\113\42\0\1\47\5\0\3\47\3\0"
          + "\16\47\3\0\1\47\1\0\1\47\17\0\1\114\50\0"
          + "\1\51\5\0\3\51\3\0\16\51\3\0\1\51\1\0"
          + "\1\51\13\0\1\115\1\71\5\0\3\71\3\0\16\71"
          + "\3\0\1\71\1\0\1\71\50\0\1\114\12\0\1\116"
          + "\60\0\1\56\5\0\3\56\3\0\16\56\3\0\1\56"
          + "\1\0\1\56\17\0\1\117\61\0\1\120\42\0\1\121"
          + "\5\0\3\122\3\0\16\122\3\0\1\121\1\0\1\123"
          + "\14\0\1\124\5\0\3\125\3\0\16\125\3\0\1\124"
          + "\1\0\1\126\14\0\1\127\5\0\3\130\3\0\16\130"
          + "\3\0\1\127\1\0\1\131\14\0\1\132\5\0\3\132"
          + "\3\0\16\132\3\0\1\132\1\0\1\132\14\0\1\71"
          + "\5\0\3\71\3\0\16\71\3\0\1\71\1\0\1\71"
          + "\1\0\3\133\10\0\1\134\3\0\1\34\1\0\3\134"
          + "\3\0\16\134\3\0\1\134\1\0\1\134\1\0\3\133"
          + "\10\0\1\134\3\0\1\34\1\0\3\134\3\0\2\134"
          + "\1\135\13\134\3\0\1\134\1\0\1\134\22\0\3\136"
          + "\3\0\16\136\3\0\1\136\24\0\3\137\3\0\16\137"
          + "\3\0\1\137\16\0\1\140\5\0\3\76\3\0\16\76"
          + "\3\0\1\140\16\0\1\141\5\0\3\142\3\0\16\142"
          + "\3\0\1\141\1\0\1\143\14\0\1\144\5\0\3\145"
          + "\3\0\16\145\3\0\1\146\1\0\1\147\14\0\1\132"
          + "\5\0\3\150\3\0\16\150\3\0\1\150\1\0\1\132"
          + "\15\0\1\151\5\0\1\152\54\0\1\153\43\0\1\127"
          + "\5\0\3\154\3\0\16\154\3\0\1\155\1\0\1\131"
          + "\14\0\1\144\5\0\3\156\3\0\16\156\3\0\1\144"
          + "\1\0\1\147\14\0\1\36\5\0\3\36\3\0\13\36"
          + "\1\157\2\36\3\0\1\36\1\0\1\36\7\0\1\160"
          + "\61\0\1\161\5\0\1\162\44\0\1\71\5\0\3\71"
          + "\3\0\11\71\1\163\4\71\3\0\1\71\1\0\1\71"
          + "\7\0\1\164\63\0\1\165\51\0\1\166\5\0\1\167"
          + "\40\0\4\64\1\121\5\0\3\121\2\0\1\64\16\121"
          + "\3\0\1\121\1\0\1\123\10\0\4\76\1\121\5\0"
          + "\3\122\2\0\1\76\16\122\3\0\1\121\1\0\1\123"
          + "\10\0\4\76\1\123\5\0\3\123\2\0\1\76\16\123"
          + "\3\0\1\123\1\0\1\123\10\0\1\64\2\65\1\64"
          + "\1\124\4\0\1\67\3\124\2\0\1\65\16\124\3\0"
          + "\1\124\1\0\1\126\10\0\1\76\2\77\1\76\1\124"
          + "\4\0\1\67\3\125\2\0\1\77\16\125\3\0\1\124"
          + "\1\0\1\126\10\0\1\76\2\77\1\76\1\126\4\0"
          + "\1\67\3\126\2\0\1\77\16\126\3\0\1\126\1\0"
          + "\1\126\10\0\1\64\1\65\1\66\1\64\1\127\4\0"
          + "\1\67\3\127\2\0\1\65\16\127\3\0\1\127\1\0"
          + "\1\131\10\0\1\76\1\77\1\105\1\76\1\127\4\0"
          + "\1\67\3\130\2\0\1\77\16\130\3\0\1\127\1\0"
          + "\1\131\10\0\1\76\1\77\1\105\1\76\1\131\4\0"
          + "\1\67\3\131\2\0\1\77\16\131\3\0\1\131\1\0"
          + "\1\131\11\0\2\170\1\0\1\132\5\0\3\132\3\0"
          + "\16\132\3\0\1\132\1\0\1\132\1\0\3\133\10\0"
          + "\1\171\5\0\3\171\3\0\16\171\3\0\1\171\1\0"
          + "\1\171\1\0\3\133\10\0\1\134\2\0\1\172\1\34"
          + "\1\0\3\134\3\0\16\134\3\0\1\134\1\0\1\134"
          + "\1\0\3\133\10\0\1\134\2\0\1\172\1\34\1\0"
          + "\3\134\3\0\3\134\1\173\12\134\3\0\1\134\1\0"
          + "\1\134\7\0\1\75\12\0\3\137\3\0\16\137\3\0"
          + "\1\137\12\0\4\174\1\140\5\0\3\140\2\0\1\174"
          + "\16\140\3\0\1\140\12\0\1\174\2\175\1\174\1\141"
          + "\4\0\1\67\3\141\2\0\1\175\16\141\3\0\1\141"
          + "\1\0\1\143\11\0\2\176\1\0\1\141\4\0\1\67"
          + "\3\142\2\0\1\176\16\142\3\0\1\141\1\0\1\143"
          + "\11\0\2\176\1\0\1\143\4\0\1\67\3\143\2\0"
          + "\1\176\16\143\3\0\1\143\1\0\1\143\10\0\1\174"
          + "\1\175\1\177\1\174\1\144\4\0\1\67\3\144\2\0"
          + "\1\175\16\144\3\0\1\144\1\0\1\147\11\0\1\176"
          + "\1\200\1\0\1\144\4\0\1\67\3\145\2\0\1\176"
          + "\16\145\3\0\1\146\1\0\1\147\10\0\1\174\1\175"
          + "\1\201\1\174\1\144\4\0\1\67\3\146\2\0\1\175"
          + "\16\146\3\0\1\146\1\0\1\147\11\0\1\176\1\202"
          + "\1\0\1\147\4\0\1\67\3\147\2\0\1\176\16\147"
          + "\3\0\1\147\1\0\1\147\11\0\2\170\1\0\1\132"
          + "\5\0\3\150\3\0\16\150\3\0\1\150\1\0\1\132"
          + "\23\0\1\152\60\0\1\203\61\0\1\204\25\0\1\76"
          + "\1\77\1\205\1\76\1\127\4\0\1\67\3\154\2\0"
          + "\1\77\16\154\3\0\1\155\1\0\1\131\10\0\1\64"
          + "\1\65\1\206\1\64\1\127\4\0\1\67\3\155\2\0"
          + "\1\65\16\155\3\0\1\155\1\0\1\131\11\0\1\176"
          + "\1\202\1\0\1\144\4\0\1\67\3\156\2\0\1\176"
          + "\16\156\3\0\1\144\1\0\1\147\14\0\1\36\5\0"
          + "\3\36\3\0\10\36\1\207\5\36\3\0\1\36\1\0"
          + "\1\36\23\0\1\162\60\0\1\210\24\0\3\133\10\0"
          + "\1\134\3\0\1\34\1\0\3\134\3\0\2\134\1\211"
          + "\13\134\3\0\1\134\1\0\1\134\7\0\1\212\67\0"
          + "\1\167\60\0\1\213\37\0\1\214\5\0\3\214\3\0"
          + "\16\214\3\0\1\214\1\0\1\214\14\0\1\171\2\0"
          + "\1\172\2\0\3\171\3\0\16\171\3\0\1\171\1\0"
          + "\1\171\4\0\1\215\50\0\3\133\10\0\1\134\2\0"
          + "\1\172\1\216\1\0\3\134\3\0\16\134\3\0\1\134"
          + "\1\0\1\134\14\0\1\123\5\0\3\123\3\0\16\123"
          + "\3\0\1\123\1\0\1\123\14\0\1\126\5\0\3\126"
          + "\3\0\16\126\3\0\1\126\1\0\1\126\14\0\1\143"
          + "\5\0\3\143\3\0\16\143\3\0\1\143\1\0\1\143"
          + "\14\0\1\131\5\0\3\131\3\0\16\131\3\0\1\131"
          + "\1\0\1\131\14\0\1\147\5\0\3\217\3\0\16\217"
          + "\3\0\1\217\1\0\1\147\14\0\1\131\5\0\3\220"
          + "\3\0\16\220\3\0\1\220\1\0\1\131\14\0\1\147"
          + "\5\0\3\147\3\0\16\147\3\0\1\147\1\0\1\147"
          + "\43\0\1\221\43\0\1\222\34\0\1\36\1\223\4\0"
          + "\3\36\3\0\12\36\1\224\3\36\3\0\1\36\1\0"
          + "\1\36\43\0\1\225\11\0\3\133\10\0\1\134\2\0"
          + "\1\172\1\34\1\0\3\134\3\0\3\134\1\226\12\134"
          + "\3\0\1\134\1\0\1\134\7\0\1\227\107\0\1\230"
          + "\21\0\2\170\1\0\1\214\5\0\3\214\3\0\16\214"
          + "\3\0\1\214\1\0\1\214\14\0\1\231\5\0\3\231"
          + "\3\0\16\231\3\0\1\231\1\0\1\231\11\0\1\176"
          + "\1\200\1\0\1\147\4\0\1\67\3\217\2\0\1\176"
          + "\16\217\3\0\1\217\1\0\1\147\10\0\1\76\1\77"
          + "\1\205\1\76\1\131\4\0\1\67\3\220\2\0\1\77"
          + "\16\220\3\0\1\220\1\0\1\131\32\0\1\232\60\0"
          + "\1\233\27\0\1\234\54\0\1\36\1\223\4\0\3\36"
          + "\3\0\16\36\3\0\1\36\1\0\1\36\32\0\1\235"
          + "\22\0\3\133\10\0\1\134\2\0\1\172\1\114\1\0"
          + "\3\134\3\0\16\134\3\0\1\134\1\0\1\134\32\0"
          + "\1\236\25\0\1\237\7\0\1\231\5\0\3\231\3\0"
          + "\16\231\3\0\1\231\1\0\1\231\34\0\1\240\50\0"
          + "\1\241\35\0\1\242\74\0\1\243\53\0\1\244\20\0"
          + "\3\133\10\0\1\171\3\0\1\34\1\0\3\171\3\0"
          + "\16\171\3\0\1\171\1\0\1\171\37\0\1\245\53\0"
          + "\1\246\30\0\1\247\5\0\3\247\3\0\16\247\3\0"
          + "\1\247\1\0\1\247\37\0\1\250\53\0\1\251\55\0"
          + "\1\252\56\0\1\253\21\0\1\254\1\0\1\247\5\0"
          + "\3\247\3\0\16\247\3\0\1\247\1\0\1\247\41\0"
          + "\1\255\53\0\1\256\57\0\1\257\35\0\1\13\40\0"
          + "\1\260\5\0\3\260\3\0\16\260\3\0\1\260\1\0"
          + "\1\260\45\0\1\261\53\0\1\262\23\0\1\263\43\0"
          + "\2\260\1\0\5\260\2\0\1\260\2\0\3\260\2\0"
          + "\17\260\3\0\1\260\1\0\1\260\15\0\1\264\53\0"
          + "\1\265\36\0";

  private static int[] zzUnpackTrans() {
    int[] result = new int[6908];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value;
      while (--count > 0);
    }
    return j;
  }

  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and {@link
   * #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState} */
  private static final int[] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
      "\12\0\1\11\10\1\1\11\1\1\1\11\5\1\1\11"
          + "\3\1\1\11\13\1\1\11\5\1\2\11\7\0\1\11"
          + "\6\0\2\1\2\0\2\11\1\1\1\0\2\1\1\11"
          + "\1\0\1\1\1\0\12\1\4\0\4\1\2\0\5\1"
          + "\3\0\4\1\1\11\3\0\1\1\1\11\12\0\2\1"
          + "\3\0\3\1\4\0\1\1\1\0\1\11\2\1\3\0"
          + "\1\1\2\0\1\11\30\0\1\1\2\0\3\11";

  private static int[] zzUnpackAttribute() {
    int[] result = new int[181];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int[] result) {
    int i = 0; /* index in packed string  */
    int j = offset; /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value;
      while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   *
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final {@link
   * #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */

  public static final int ALPHANUM = WikipediaTokenizer.ALPHANUM_ID;
  public static final int APOSTROPHE = WikipediaTokenizer.APOSTROPHE_ID;
  public static final int ACRONYM = WikipediaTokenizer.ACRONYM_ID;
  public static final int COMPANY = WikipediaTokenizer.COMPANY_ID;
  public static final int EMAIL = WikipediaTokenizer.EMAIL_ID;
  public static final int HOST = WikipediaTokenizer.HOST_ID;
  public static final int NUM = WikipediaTokenizer.NUM_ID;
  public static final int CJ = WikipediaTokenizer.CJ_ID;
  public static final int INTERNAL_LINK = WikipediaTokenizer.INTERNAL_LINK_ID;
  public static final int EXTERNAL_LINK = WikipediaTokenizer.EXTERNAL_LINK_ID;
  public static final int CITATION = WikipediaTokenizer.CITATION_ID;
  public static final int CATEGORY = WikipediaTokenizer.CATEGORY_ID;
  public static final int BOLD = WikipediaTokenizer.BOLD_ID;
  public static final int ITALICS = WikipediaTokenizer.ITALICS_ID;
  public static final int BOLD_ITALICS = WikipediaTokenizer.BOLD_ITALICS_ID;
  public static final int HEADING = WikipediaTokenizer.HEADING_ID;
  public static final int SUB_HEADING = WikipediaTokenizer.SUB_HEADING_ID;
  public static final int EXTERNAL_LINK_URL = WikipediaTokenizer.EXTERNAL_LINK_URL_ID;

  private int currentTokType;
  private int numBalanced = 0;
  private int positionInc = 1;
  private int numLinkToks = 0;
  // Anytime we start a new on a Wiki reserved token (category, link, etc.) this value will be 0,
  // otherwise it will be the number of tokens seen
  // this can be useful for detecting when a new reserved token is encountered
  // see https://issues.apache.org/jira/browse/LUCENE-1133
  private int numWikiTokensSeen = 0;

  public static final String[] TOKEN_TYPES = WikipediaTokenizer.TOKEN_TYPES;

  /**
   * Returns the number of tokens seen inside a category or link, etc.
   *
   * @return the number of tokens seen inside the context of wiki syntax.
   */
  public final int getNumWikiTokensSeen() {
    return numWikiTokensSeen;
  }

  public final int yychar() {
    // jflex supports > 2GB docs but not lucene
    return (int) yychar;
  }

  public final int getPositionIncrement() {
    return positionInc;
  }

  /** Fills Lucene token with the current token text. */
  final void getText(CharTermAttribute t) {
    t.copyBuffer(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
  }

  final int setText(StringBuilder buffer) {
    int length = zzMarkedPos - zzStartRead;
    buffer.append(zzBuffer, zzStartRead, length);
    return length;
  }

  final void reset() {
    currentTokType = 0;
    numBalanced = 0;
    positionInc = 1;
    numLinkToks = 0;
    numWikiTokensSeen = 0;
  }

  /**
   * Creates a new scanner
   *
   * @param in the java.io.Reader to read input from.
   */
  WikipediaTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  /** Translates raw input code points to DFA table row */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input
        ? ZZ_CMAP_BLOCKS[offset]
        : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead, zzBuffer, 0, zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else { // There is room in the buffer for at least one more char
          int c = zzReader.read(); // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char) c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }

  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /** Resets the input position. */
  private final void yyResetPosition() {
    zzAtBOL = true;
    zzAtEOF = false;
    zzCurrentPos = 0;
    zzMarkedPos = 0;
    zzStartRead = 0;
    zzEndRead = 0;
    zzFinalHighSurrogate = 0;
    yyline = 0;
    yycolumn = 0;
    yychar = 0L;
  }

  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }

  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }

  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }

  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
  }

  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }

  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos - zzStartRead;
  }

  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that "Can't Possibly
   * Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }

  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number) {
    if (number > yylength()) zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }

  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int[] zzTransL = ZZ_TRANS;
    int[] zzRowMapL = ZZ_ROWMAP;
    int[] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar += zzMarkedPosL - zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ((zzAttributes & 1) == 1) {
        zzAction = zzState;
      }

      zzForAction:
      {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          } else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          } else {
            // store back cached positions
            zzCurrentPos = zzCurrentPosL;
            zzMarkedPos = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL = zzCurrentPos;
            zzMarkedPosL = zzMarkedPos;
            zzBufferL = zzBuffer;
            zzEndReadL = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            } else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[zzRowMapL[zzState] + zzCMap(zzInput)];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ((zzAttributes & 1) == 1) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ((zzAttributes & 8) == 8) break zzForAction;
          }
        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return YYEOF;
      } else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            {
              numWikiTokensSeen = 0;
              positionInc = 1; /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 47:
            break;
          case 2:
            {
              positionInc = 1;
              return ALPHANUM;
            }
            // fall through
          case 48:
            break;
          case 3:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              currentTokType = EXTERNAL_LINK_URL;
              yybegin(EXTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 49:
            break;
          case 4:
            {
              positionInc = 1;
              return CJ;
            }
            // fall through
          case 50:
            break;
          case 5:
            {
              positionInc = 1; /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 51:
            break;
          case 6:
            {
              yybegin(CATEGORY_STATE);
              numWikiTokensSeen++;
              return currentTokType;
            }
            // fall through
          case 52:
            break;
          case 7:
            {
              yybegin(INTERNAL_LINK_STATE);
              numWikiTokensSeen++;
              return currentTokType;
            }
            // fall through
          case 53:
            break;
          case 8:
            {
              /* Break so we don't hit fall-through warning: */
              break; /* ignore */
            }
            // fall through
          case 54:
            break;
          case 9:
            {
              if (numLinkToks == 0) {
                positionInc = 0;
              } else {
                positionInc = 1;
              }
              numWikiTokensSeen++;
              currentTokType = EXTERNAL_LINK;
              yybegin(EXTERNAL_LINK_STATE);
              numLinkToks++;
              return currentTokType;
            }
            // fall through
          case 55:
            break;
          case 10:
            {
              numLinkToks = 0;
              positionInc = 0;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 56:
            break;
          case 11:
            {
              currentTokType = BOLD;
              yybegin(THREE_SINGLE_QUOTES_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 57:
            break;
          case 12:
            {
              currentTokType = ITALICS;
              numWikiTokensSeen++;
              yybegin(STRING);
              return currentTokType; /*italics*/
            }
            // fall through
          case 58:
            break;
          case 13:
            {
              currentTokType = EXTERNAL_LINK;
              numWikiTokensSeen = 0;
              yybegin(EXTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 59:
            break;
          case 14:
            {
              yybegin(STRING);
              numWikiTokensSeen++;
              return currentTokType;
            }
            // fall through
          case 60:
            break;
          case 15:
            {
              currentTokType = HEADING;
              yybegin(DOUBLE_EQUALS_STATE);
              numWikiTokensSeen++;
              return currentTokType;
            }
            // fall through
          case 61:
            break;
          case 16:
            {
              currentTokType = SUB_HEADING;
              numWikiTokensSeen = 0;
              yybegin(STRING); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 62:
            break;
          case 17:
            {
              yybegin(DOUBLE_BRACE_STATE);
              numWikiTokensSeen = 0;
              return currentTokType;
            }
            // fall through
          case 63:
            break;
          case 18:
            {
              /* Break so we don't hit fall-through warning: */
              break; /* ignore STRING */
            }
            // fall through
          case 64:
            break;
          case 19:
            {
              yybegin(STRING);
              numWikiTokensSeen++;
              return currentTokType; /* STRING ALPHANUM*/
            }
            // fall through
          case 65:
            break;
          case 20:
            {
              numBalanced = 0;
              numWikiTokensSeen = 0;
              currentTokType = EXTERNAL_LINK;
              yybegin(EXTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 66:
            break;
          case 21:
            {
              yybegin(STRING);
              return currentTokType; /*pipe*/
            }
            // fall through
          case 67:
            break;
          case 22:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              if (numBalanced == 0) {
                numBalanced++;
                yybegin(TWO_SINGLE_QUOTES_STATE);
              } else {
                numBalanced = 0;
              } /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 68:
            break;
          case 23:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              yybegin(DOUBLE_EQUALS_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 69:
            break;
          case 24:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              currentTokType = INTERNAL_LINK;
              yybegin(INTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 70:
            break;
          case 25:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              currentTokType = CITATION;
              yybegin(DOUBLE_BRACE_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 71:
            break;
          case 26:
            {
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 72:
            break;
          case 27:
            {
              numLinkToks = 0;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 73:
            break;
          case 28:
            {
              currentTokType = INTERNAL_LINK;
              numWikiTokensSeen = 0;
              yybegin(INTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 74:
            break;
          case 29:
            {
              currentTokType = INTERNAL_LINK;
              numWikiTokensSeen = 0;
              yybegin(INTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 75:
            break;
          case 30:
            {
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 76:
            break;
          case 31:
            {
              numBalanced = 0;
              currentTokType = ALPHANUM;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break; /*end italics*/
            }
            // fall through
          case 77:
            break;
          case 32:
            {
              numBalanced = 0;
              numWikiTokensSeen = 0;
              currentTokType = INTERNAL_LINK;
              yybegin(INTERNAL_LINK_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 78:
            break;
          case 33:
            {
              positionInc = 1;
              return NUM;
            }
            // fall through
          case 79:
            break;
          case 34:
            {
              positionInc = 1;
              return COMPANY;
            }
            // fall through
          case 80:
            break;
          case 35:
            {
              positionInc = 1;
              return APOSTROPHE;
            }
            // fall through
          case 81:
            break;
          case 36:
            {
              positionInc = 1;
              return HOST;
            }
            // fall through
          case 82:
            break;
          case 37:
            {
              currentTokType = BOLD_ITALICS;
              yybegin(FIVE_SINGLE_QUOTES_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 83:
            break;
          case 38:
            {
              numBalanced = 0;
              currentTokType = ALPHANUM;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break; /*end bold*/
            }
            // fall through
          case 84:
            break;
          case 39:
            {
              numBalanced = 0;
              currentTokType = ALPHANUM;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break; /*end sub header*/
            }
            // fall through
          case 85:
            break;
          case 40:
            {
              positionInc = 1;
              return ACRONYM;
            }
            // fall through
          case 86:
            break;
          case 41:
            {
              positionInc = 1;
              return EMAIL;
            }
            // fall through
          case 87:
            break;
          case 42:
            {
              numBalanced = 0;
              currentTokType = ALPHANUM;
              yybegin(YYINITIAL); /* Break so we don't hit fall-through warning: */
              break; /*end bold italics*/
            }
            // fall through
          case 88:
            break;
          case 43:
            {
              positionInc = 1;
              numWikiTokensSeen++;
              yybegin(EXTERNAL_LINK_STATE);
              return currentTokType;
            }
            // fall through
          case 89:
            break;
          case 44:
            {
              numWikiTokensSeen = 0;
              positionInc = 1;
              currentTokType = CATEGORY;
              yybegin(CATEGORY_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 90:
            break;
          case 45:
            {
              currentTokType = CATEGORY;
              numWikiTokensSeen = 0;
              yybegin(CATEGORY_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 91:
            break;
          case 46:
            {
              numBalanced = 0;
              numWikiTokensSeen = 0;
              currentTokType = CATEGORY;
              yybegin(CATEGORY_STATE); /* Break so we don't hit fall-through warning: */
              break;
            }
            // fall through
          case 92:
            break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }
}
