/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.simple;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.PropsUtil;

public class SimpleLogger
extends AbstractLogger {
    private DateFormat dateFormatter = null;
    private Level level;
    private boolean showDateTime;
    private boolean showContextMap;
    private PrintStream stream;
    private String logName;

    public SimpleLogger(String name, Level defaultLevel, boolean showLogName, boolean showShortLogName, boolean showDateTime, boolean showContextMap, String dateTimeFormat, PropsUtil props, PrintStream stream) {
        super(name);
        String lvl = props.getStringProperty("org.apache.logging.log4j.simplelog." + name + ".level");
        this.level = Level.toLevel(lvl, defaultLevel);
        if (showShortLogName) {
            int index = name.lastIndexOf(".");
            this.logName = index > 0 && index < name.length() ? name.substring(index + 1) : name;
        } else if (showLogName) {
            this.logName = name;
        }
        this.showDateTime = showDateTime;
        this.showContextMap = showContextMap;
        this.stream = stream;
        if (showDateTime) {
            try {
                this.dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                this.dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS zzz");
            }
        }
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Marker marker, String fqcn, Level level, Message msg, Throwable throwable) {
        Map<String, String> mdc;
        StringBuilder sb = new StringBuilder();
        if (this.showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = this.dateFormatter;
            synchronized (dateFormat) {
                dateText = this.dateFormatter.format(now);
            }
            sb.append(dateText);
            sb.append(" ");
        }
        sb.append(level.toString());
        sb.append(" ");
        if (this.logName != null && this.logName.length() > 0) {
            sb.append(this.logName);
            sb.append(" ");
        }
        sb.append(msg.getFormattedMessage());
        if (this.showContextMap && (mdc = ThreadContext.getContext()).size() > 0) {
            sb.append(" ");
            sb.append(mdc.toString());
            sb.append(" ");
        }
        Object[] params = msg.getParameters();
        Throwable t = throwable == null && params != null && params[params.length - 1] instanceof Throwable ? (Throwable)params[params.length - 1] : throwable;
        if (t != null) {
            sb.append(" ");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            sb.append(baos.toString());
        }
        this.stream.println(sb.toString());
    }

    protected boolean isEnabled(Level level, Marker marker, String msg) {
        return this.level.intLevel() >= level.intLevel();
    }

    protected boolean isEnabled(Level level, Marker marker, String msg, Throwable t) {
        return this.level.intLevel() >= level.intLevel();
    }

    protected boolean isEnabled(Level level, Marker marker, String msg, Object ... p1) {
        return this.level.intLevel() >= level.intLevel();
    }

    protected boolean isEnabled(Level level, Marker marker, Object msg, Throwable t) {
        return this.level.intLevel() >= level.intLevel();
    }

    protected boolean isEnabled(Level level, Marker marker, Message msg, Throwable t) {
        return this.level.intLevel() >= level.intLevel();
    }
}

