/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidatorFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.FileTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerLoginCallbackHandlerTest
extends OAuthBearerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleTokenCallback() throws Exception {
        Map<String, ?> configs = this.getSaslConfigs();
        AccessTokenBuilder builder = new AccessTokenBuilder().jwk(this.createRsaJwk()).alg("RS256");
        String accessToken = builder.build();
        AccessTokenRetriever accessTokenRetriever = () -> accessToken;
        try (OAuthBearerLoginCallbackHandler handler = this.createHandler(accessTokenRetriever, configs);){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.token());
            OAuthBearerToken token = callback.token();
            Assertions.assertEquals((Object)accessToken, (Object)token.value());
            Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
            Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
            Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleSaslExtensionsCallback() throws Exception {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        HashMap<String, Object> jaasConfig = new HashMap<String, Object>();
        jaasConfig.put("clientId", "an ID");
        jaasConfig.put("clientSecret", "a secret");
        jaasConfig.put("extension_foo", "1");
        jaasConfig.put("extension_bar", 2);
        jaasConfig.put("EXTENSION_baz", "3");
        this.configureHandler((AuthenticateCallbackHandler)handler, configs, jaasConfig);
        try {
            SaslExtensionsCallback callback = new SaslExtensionsCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.extensions());
            Map extensions = callback.extensions().map();
            Assertions.assertEquals((Object)"1", extensions.get("foo"));
            Assertions.assertEquals((Object)"2", extensions.get("bar"));
            Assertions.assertNull(extensions.get("baz"));
            Assertions.assertEquals((int)2, (int)extensions.size());
        }
        finally {
            handler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleSaslExtensionsCallbackWithInvalidExtension() {
        String illegalKey = "extension_auth";
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        HashMap<String, Object> jaasConfig = new HashMap<String, Object>();
        jaasConfig.put("clientId", "an ID");
        jaasConfig.put("clientSecret", "a secret");
        jaasConfig.put(illegalKey, "this key isn't allowed per OAuthBearerClientInitialResponse.validateExtensions");
        this.configureHandler((AuthenticateCallbackHandler)handler, configs, jaasConfig);
        try {
            SaslExtensionsCallback callback = new SaslExtensionsCallback();
            this.assertThrowsWithMessage(ConfigException.class, () -> handler.handle(new Callback[]{callback}), "Extension name auth is invalid");
        }
        finally {
            handler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCallbackGeneratesUnsupportedCallbackException() {
        Map<String, ?> configs = this.getSaslConfigs();
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        AccessTokenRetriever accessTokenRetriever = () -> "foo";
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs);
        handler.init(accessTokenRetriever, accessTokenValidator);
        try {
            Callback unsupportedCallback = new Callback(){};
            Assertions.assertThrows(UnsupportedCallbackException.class, () -> handler.handle(new Callback[]{unsupportedCallback}));
        }
        finally {
            handler.close();
        }
    }

    @Test
    public void testInvalidAccessToken() throws Exception {
        this.testInvalidAccessToken("this isn't valid", "Malformed JWT provided");
        this.testInvalidAccessToken("this.isn't.valid", "malformed Base64 URL encoded value");
        this.testInvalidAccessToken(this.createAccessKey("this", "isn't", "valid"), "malformed JSON");
        this.testInvalidAccessToken(this.createAccessKey("{}", "{}", "{}"), "exp value must be non-null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingAccessToken() {
        AccessTokenRetriever accessTokenRetriever = () -> {
            throw new IOException("The token endpoint response access_token value must be non-null");
        };
        Map<String, ?> configs = this.getSaslConfigs();
        try (OAuthBearerLoginCallbackHandler handler = this.createHandler(accessTokenRetriever, configs);){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            this.assertThrowsWithMessage(IOException.class, () -> handler.handle(new Callback[]{callback}), "token endpoint response access_token value must be non-null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTokenRetrieverHandlesNewline() throws IOException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        long cur = cal.getTimeInMillis() / 1000L;
        String exp = "" + (cur + 3600L);
        String iat = "" + cur;
        String expected = this.createAccessKey("{}", String.format("{\"exp\":%s, \"iat\":%s, \"sub\":\"subj\"}", exp, iat), "sign");
        String withNewline = expected + "\n";
        File tmpDir = this.createTempDir("access-token");
        File accessTokenFile = this.createTempFile(tmpDir, "access-token-", ".json", withNewline);
        Map<String, ?> configs = this.getSaslConfigs();
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        try (OAuthBearerLoginCallbackHandler handler = this.createHandler((AccessTokenRetriever)new FileTokenRetriever(accessTokenFile.toPath()), configs);){
            handler.handle(new Callback[]{callback});
            Assertions.assertEquals((Object)callback.token().value(), (Object)expected);
        }
    }

    @Test
    public void testNotConfigured() {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        this.assertThrowsWithMessage(IllegalStateException.class, () -> handler.handle(new Callback[0]), "first call the configure or init method");
    }

    @Test
    public void testConfigureWithAccessTokenFile() throws Exception {
        String expected = "{}";
        File tmpDir = this.createTempDir("access-token");
        File accessTokenFile = this.createTempFile(tmpDir, "access-token-", ".json", expected);
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", accessTokenFile.toURI().toString());
        Map<String, Object> jaasConfigs = Collections.emptyMap();
        this.configureHandler((AuthenticateCallbackHandler)handler, configs, jaasConfigs);
        Assertions.assertTrue((boolean)(handler.getAccessTokenRetriever() instanceof FileTokenRetriever));
    }

    @Test
    public void testConfigureWithAccessClientCredentials() {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.token.endpoint.url", "http://www.example.com");
        HashMap<String, Object> jaasConfigs = new HashMap<String, Object>();
        jaasConfigs.put("clientId", "an ID");
        jaasConfigs.put("clientSecret", "a secret");
        this.configureHandler((AuthenticateCallbackHandler)handler, configs, jaasConfigs);
        Assertions.assertTrue((boolean)(handler.getAccessTokenRetriever() instanceof HttpAccessTokenRetriever));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidAccessToken(String accessToken, String expectedMessageSubstring) throws Exception {
        Map<String, ?> configs = this.getSaslConfigs();
        try (OAuthBearerLoginCallbackHandler handler = this.createHandler(() -> accessToken, configs);){
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            handler.handle(new Callback[]{callback});
            Assertions.assertNull((Object)callback.token());
            String actualMessage = callback.errorDescription();
            Assertions.assertNotNull((Object)actualMessage);
            Assertions.assertTrue((boolean)actualMessage.contains(expectedMessageSubstring), (String)String.format("The error message \"%s\" didn't contain the expected substring \"%s\"", actualMessage, expectedMessageSubstring));
        }
    }

    private String createAccessKey(String header, String payload, String signature) {
        Base64.Encoder enc = Base64.getEncoder();
        header = enc.encodeToString(Utils.utf8((String)header));
        payload = enc.encodeToString(Utils.utf8((String)payload));
        signature = enc.encodeToString(Utils.utf8((String)signature));
        return String.format("%s.%s.%s", header, payload, signature);
    }

    private OAuthBearerLoginCallbackHandler createHandler(AccessTokenRetriever accessTokenRetriever, Map<String, ?> configs) {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs);
        handler.init(accessTokenRetriever, accessTokenValidator);
        return handler;
    }
}

