/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

import static org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection;


public class ConsumerGroupHeartbeatRequestData implements ApiMessage {
    String groupId;
    String memberId;
    int memberEpoch;
    String instanceId;
    String rackId;
    int rebalanceTimeoutMs;
    List<String> subscribedTopicNames;
    String subscribedTopicRegex;
    String serverAssignor;
    List<Assignor> clientAssignors;
    List<TopicPartitions> topicPartitions;
    private List<RawTaggedField> _unknownTaggedFields;
    
    public static final Schema SCHEMA_0 =
        new Schema(
            new Field("group_id", Type.COMPACT_STRING, "The group identifier."),
            new Field("member_id", Type.COMPACT_STRING, "The member id generated by the coordinator. The member id must be kept during the entire lifetime of the member."),
            new Field("member_epoch", Type.INT32, "The current member epoch; 0 to join the group; -1 to leave the group; -2 to indicate that the static member will rejoin."),
            new Field("instance_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the instance Id otherwise."),
            new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the rack ID of consumer otherwise."),
            new Field("rebalance_timeout_ms", Type.INT32, "-1 if it didn't chance since the last heartbeat; the maximum time in milliseconds that the coordinator will wait on the member to revoke its partitions otherwise."),
            new Field("subscribed_topic_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "null if it didn't change since the last heartbeat; the subscribed topic names otherwise."),
            new Field("subscribed_topic_regex", Type.COMPACT_NULLABLE_STRING, "null if it didn't change since the last heartbeat; the subscribed topic regex otherwise"),
            new Field("server_assignor", Type.COMPACT_NULLABLE_STRING, "null if not used or if it didn't change since the last heartbeat; the server side assignor to use otherwise."),
            new Field("client_assignors", CompactArrayOf.nullable(Assignor.SCHEMA_0), "null if not used or if it didn't change since the last heartbeat; the list of client-side assignors otherwise."),
            new Field("topic_partitions", CompactArrayOf.nullable(TopicPartitions.SCHEMA_0), "null if it didn't change since the last heartbeat; the partitions owned by the member."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema[] SCHEMAS = new Schema[] {
        SCHEMA_0
    };
    
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    
    public ConsumerGroupHeartbeatRequestData(Readable _readable, short _version) {
        read(_readable, _version);
    }
    
    public ConsumerGroupHeartbeatRequestData() {
        this.groupId = "";
        this.memberId = "";
        this.memberEpoch = 0;
        this.instanceId = null;
        this.rackId = null;
        this.rebalanceTimeoutMs = -1;
        this.subscribedTopicNames = null;
        this.subscribedTopicRegex = null;
        this.serverAssignor = null;
        this.clientAssignors = null;
        this.topicPartitions = null;
    }
    
    @Override
    public short apiKey() {
        return 68;
    }
    
    @Override
    public short lowestSupportedVersion() {
        return 0;
    }
    
    @Override
    public short highestSupportedVersion() {
        return 0;
    }
    
    @Override
    public void read(Readable _readable, short _version) {
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            } else {
                this.groupId = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            } else {
                this.memberId = _readable.readString(length);
            }
        }
        this.memberEpoch = _readable.readInt();
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.instanceId = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field instanceId had invalid length " + length);
            } else {
                this.instanceId = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rackId = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            } else {
                this.rackId = _readable.readString(length);
            }
        }
        this.rebalanceTimeoutMs = _readable.readInt();
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.subscribedTopicNames = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<String> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    int length;
                    length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
                    } else if (length > 0x7fff) {
                        throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length);
                    } else {
                        newCollection.add(_readable.readString(length));
                    }
                }
                this.subscribedTopicNames = newCollection;
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.subscribedTopicRegex = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field subscribedTopicRegex had invalid length " + length);
            } else {
                this.subscribedTopicRegex = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.serverAssignor = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field serverAssignor had invalid length " + length);
            } else {
                this.serverAssignor = _readable.readString(length);
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.clientAssignors = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Assignor> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new Assignor(_readable, _version));
                }
                this.clientAssignors = newCollection;
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topicPartitions = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TopicPartitions> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new TopicPartitions(_readable, _version));
                }
                this.topicPartitions = newCollection;
            }
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; _i++) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default:
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    break;
            }
        }
    }
    
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        {
            byte[] _stringBytes = _cache.getSerializedValue(groupId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        {
            byte[] _stringBytes = _cache.getSerializedValue(memberId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(memberEpoch);
        if (instanceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(instanceId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(rackId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(rebalanceTimeoutMs);
        if (subscribedTopicNames == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(subscribedTopicNames.size() + 1);
            for (String subscribedTopicNamesElement : subscribedTopicNames) {
                {
                    byte[] _stringBytes = _cache.getSerializedValue(subscribedTopicNamesElement);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            }
        }
        if (subscribedTopicRegex == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(subscribedTopicRegex);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (serverAssignor == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(serverAssignor);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (clientAssignors == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(clientAssignors.size() + 1);
            for (Assignor clientAssignorsElement : clientAssignors) {
                clientAssignorsElement.write(_writable, _cache, _version);
            }
        }
        if (topicPartitions == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(topicPartitions.size() + 1);
            for (TopicPartitions topicPartitionsElement : topicPartitions) {
                topicPartitionsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        _writable.writeUnsignedVarint(_numTaggedFields);
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }
    
    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        {
            byte[] _stringBytes = groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        {
            byte[] _stringBytes = memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        if (instanceId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = instanceId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'instanceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(instanceId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (rackId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = rackId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(rackId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        if (subscribedTopicNames == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(subscribedTopicNames.size() + 1));
            for (String subscribedTopicNamesElement : subscribedTopicNames) {
                byte[] _stringBytes = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subscribedTopicNamesElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (subscribedTopicRegex == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = subscribedTopicRegex.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'subscribedTopicRegex' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(subscribedTopicRegex, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (serverAssignor == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = serverAssignor.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'serverAssignor' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(serverAssignor, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (clientAssignors == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(clientAssignors.size() + 1));
            for (Assignor clientAssignorsElement : clientAssignors) {
                clientAssignorsElement.addSize(_size, _cache, _version);
            }
        }
        if (topicPartitions == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(topicPartitions.size() + 1));
            for (TopicPartitions topicPartitionsElement : topicPartitions) {
                topicPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        if (_unknownTaggedFields != null) {
            _numTaggedFields += _unknownTaggedFields.size();
            for (RawTaggedField _field : _unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerGroupHeartbeatRequestData)) return false;
        ConsumerGroupHeartbeatRequestData other = (ConsumerGroupHeartbeatRequestData) obj;
        if (this.groupId == null) {
            if (other.groupId != null) return false;
        } else {
            if (!this.groupId.equals(other.groupId)) return false;
        }
        if (this.memberId == null) {
            if (other.memberId != null) return false;
        } else {
            if (!this.memberId.equals(other.memberId)) return false;
        }
        if (memberEpoch != other.memberEpoch) return false;
        if (this.instanceId == null) {
            if (other.instanceId != null) return false;
        } else {
            if (!this.instanceId.equals(other.instanceId)) return false;
        }
        if (this.rackId == null) {
            if (other.rackId != null) return false;
        } else {
            if (!this.rackId.equals(other.rackId)) return false;
        }
        if (rebalanceTimeoutMs != other.rebalanceTimeoutMs) return false;
        if (this.subscribedTopicNames == null) {
            if (other.subscribedTopicNames != null) return false;
        } else {
            if (!this.subscribedTopicNames.equals(other.subscribedTopicNames)) return false;
        }
        if (this.subscribedTopicRegex == null) {
            if (other.subscribedTopicRegex != null) return false;
        } else {
            if (!this.subscribedTopicRegex.equals(other.subscribedTopicRegex)) return false;
        }
        if (this.serverAssignor == null) {
            if (other.serverAssignor != null) return false;
        } else {
            if (!this.serverAssignor.equals(other.serverAssignor)) return false;
        }
        if (this.clientAssignors == null) {
            if (other.clientAssignors != null) return false;
        } else {
            if (!this.clientAssignors.equals(other.clientAssignors)) return false;
        }
        if (this.topicPartitions == null) {
            if (other.topicPartitions != null) return false;
        } else {
            if (!this.topicPartitions.equals(other.topicPartitions)) return false;
        }
        return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
    }
    
    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (groupId == null ? 0 : groupId.hashCode());
        hashCode = 31 * hashCode + (memberId == null ? 0 : memberId.hashCode());
        hashCode = 31 * hashCode + memberEpoch;
        hashCode = 31 * hashCode + (instanceId == null ? 0 : instanceId.hashCode());
        hashCode = 31 * hashCode + (rackId == null ? 0 : rackId.hashCode());
        hashCode = 31 * hashCode + rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (subscribedTopicNames == null ? 0 : subscribedTopicNames.hashCode());
        hashCode = 31 * hashCode + (subscribedTopicRegex == null ? 0 : subscribedTopicRegex.hashCode());
        hashCode = 31 * hashCode + (serverAssignor == null ? 0 : serverAssignor.hashCode());
        hashCode = 31 * hashCode + (clientAssignors == null ? 0 : clientAssignors.hashCode());
        hashCode = 31 * hashCode + (topicPartitions == null ? 0 : topicPartitions.hashCode());
        return hashCode;
    }
    
    @Override
    public ConsumerGroupHeartbeatRequestData duplicate() {
        ConsumerGroupHeartbeatRequestData _duplicate = new ConsumerGroupHeartbeatRequestData();
        _duplicate.groupId = groupId;
        _duplicate.memberId = memberId;
        _duplicate.memberEpoch = memberEpoch;
        if (instanceId == null) {
            _duplicate.instanceId = null;
        } else {
            _duplicate.instanceId = instanceId;
        }
        if (rackId == null) {
            _duplicate.rackId = null;
        } else {
            _duplicate.rackId = rackId;
        }
        _duplicate.rebalanceTimeoutMs = rebalanceTimeoutMs;
        if (subscribedTopicNames == null) {
            _duplicate.subscribedTopicNames = null;
        } else {
            ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(subscribedTopicNames.size());
            for (String _element : subscribedTopicNames) {
                newSubscribedTopicNames.add(_element);
            }
            _duplicate.subscribedTopicNames = newSubscribedTopicNames;
        }
        if (subscribedTopicRegex == null) {
            _duplicate.subscribedTopicRegex = null;
        } else {
            _duplicate.subscribedTopicRegex = subscribedTopicRegex;
        }
        if (serverAssignor == null) {
            _duplicate.serverAssignor = null;
        } else {
            _duplicate.serverAssignor = serverAssignor;
        }
        if (clientAssignors == null) {
            _duplicate.clientAssignors = null;
        } else {
            ArrayList<Assignor> newClientAssignors = new ArrayList<Assignor>(clientAssignors.size());
            for (Assignor _element : clientAssignors) {
                newClientAssignors.add(_element.duplicate());
            }
            _duplicate.clientAssignors = newClientAssignors;
        }
        if (topicPartitions == null) {
            _duplicate.topicPartitions = null;
        } else {
            ArrayList<TopicPartitions> newTopicPartitions = new ArrayList<TopicPartitions>(topicPartitions.size());
            for (TopicPartitions _element : topicPartitions) {
                newTopicPartitions.add(_element.duplicate());
            }
            _duplicate.topicPartitions = newTopicPartitions;
        }
        return _duplicate;
    }
    
    @Override
    public String toString() {
        return "ConsumerGroupHeartbeatRequestData("
            + "groupId=" + ((groupId == null) ? "null" : "'" + groupId.toString() + "'")
            + ", memberId=" + ((memberId == null) ? "null" : "'" + memberId.toString() + "'")
            + ", memberEpoch=" + memberEpoch
            + ", instanceId=" + ((instanceId == null) ? "null" : "'" + instanceId.toString() + "'")
            + ", rackId=" + ((rackId == null) ? "null" : "'" + rackId.toString() + "'")
            + ", rebalanceTimeoutMs=" + rebalanceTimeoutMs
            + ", subscribedTopicNames=" + ((subscribedTopicNames == null) ? "null" : MessageUtil.deepToString(subscribedTopicNames.iterator()))
            + ", subscribedTopicRegex=" + ((subscribedTopicRegex == null) ? "null" : "'" + subscribedTopicRegex.toString() + "'")
            + ", serverAssignor=" + ((serverAssignor == null) ? "null" : "'" + serverAssignor.toString() + "'")
            + ", clientAssignors=" + ((clientAssignors == null) ? "null" : MessageUtil.deepToString(clientAssignors.iterator()))
            + ", topicPartitions=" + ((topicPartitions == null) ? "null" : MessageUtil.deepToString(topicPartitions.iterator()))
            + ")";
    }
    
    public String groupId() {
        return this.groupId;
    }
    
    public String memberId() {
        return this.memberId;
    }
    
    public int memberEpoch() {
        return this.memberEpoch;
    }
    
    public String instanceId() {
        return this.instanceId;
    }
    
    public String rackId() {
        return this.rackId;
    }
    
    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }
    
    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }
    
    public String subscribedTopicRegex() {
        return this.subscribedTopicRegex;
    }
    
    public String serverAssignor() {
        return this.serverAssignor;
    }
    
    public List<Assignor> clientAssignors() {
        return this.clientAssignors;
    }
    
    public List<TopicPartitions> topicPartitions() {
        return this.topicPartitions;
    }
    
    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (_unknownTaggedFields == null) {
            _unknownTaggedFields = new ArrayList<>(0);
        }
        return _unknownTaggedFields;
    }
    
    public ConsumerGroupHeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setInstanceId(String v) {
        this.instanceId = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setSubscribedTopicNames(List<String> v) {
        this.subscribedTopicNames = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setSubscribedTopicRegex(String v) {
        this.subscribedTopicRegex = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setServerAssignor(String v) {
        this.serverAssignor = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setClientAssignors(List<Assignor> v) {
        this.clientAssignors = v;
        return this;
    }
    
    public ConsumerGroupHeartbeatRequestData setTopicPartitions(List<TopicPartitions> v) {
        this.topicPartitions = v;
        return this;
    }
    
    public static class Assignor implements Message {
        String name;
        short minimumVersion;
        short maximumVersion;
        byte reason;
        short metadataVersion;
        byte[] metadataBytes;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("name", Type.COMPACT_STRING, "The name of the assignor."),
                new Field("minimum_version", Type.INT16, "The minimum supported version for the metadata."),
                new Field("maximum_version", Type.INT16, "The maximum supported version for the metadata."),
                new Field("reason", Type.INT8, "The reason of the metadata update."),
                new Field("metadata_version", Type.INT16, "The version of the metadata."),
                new Field("metadata_bytes", Type.COMPACT_BYTES, "The metadata."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public Assignor(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public Assignor() {
            this.name = "";
            this.minimumVersion = (short) 0;
            this.maximumVersion = (short) 0;
            this.reason = (byte) 0;
            this.metadataVersion = (short) 0;
            this.metadataBytes = Bytes.EMPTY;
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 0;
        }
        
        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Assignor");
            }
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field name was serialized as null");
                } else if (length > 0x7fff) {
                    throw new RuntimeException("string field name had invalid length " + length);
                } else {
                    this.name = _readable.readString(length);
                }
            }
            this.minimumVersion = _readable.readShort();
            this.maximumVersion = _readable.readShort();
            this.reason = _readable.readByte();
            this.metadataVersion = _readable.readShort();
            {
                int length;
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field metadataBytes was serialized as null");
                } else {
                    byte[] newBytes = _readable.readArray(length);
                    this.metadataBytes = newBytes;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            {
                byte[] _stringBytes = _cache.getSerializedValue(name);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(minimumVersion);
            _writable.writeShort(maximumVersion);
            _writable.writeByte(reason);
            _writable.writeShort(metadataVersion);
            _writable.writeUnsignedVarint(metadataBytes.length + 1);
            _writable.writeByteArray(metadataBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Assignor");
            }
            {
                byte[] _stringBytes = name.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(name, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(2);
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(2);
            {
                _size.addBytes(metadataBytes.length);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(metadataBytes.length + 1));
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Assignor)) return false;
            Assignor other = (Assignor) obj;
            if (this.name == null) {
                if (other.name != null) return false;
            } else {
                if (!this.name.equals(other.name)) return false;
            }
            if (minimumVersion != other.minimumVersion) return false;
            if (maximumVersion != other.maximumVersion) return false;
            if (reason != other.reason) return false;
            if (metadataVersion != other.metadataVersion) return false;
            if (!Arrays.equals(this.metadataBytes, other.metadataBytes)) return false;
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (name == null ? 0 : name.hashCode());
            hashCode = 31 * hashCode + minimumVersion;
            hashCode = 31 * hashCode + maximumVersion;
            hashCode = 31 * hashCode + reason;
            hashCode = 31 * hashCode + metadataVersion;
            hashCode = 31 * hashCode + Arrays.hashCode(metadataBytes);
            return hashCode;
        }
        
        @Override
        public Assignor duplicate() {
            Assignor _duplicate = new Assignor();
            _duplicate.name = name;
            _duplicate.minimumVersion = minimumVersion;
            _duplicate.maximumVersion = maximumVersion;
            _duplicate.reason = reason;
            _duplicate.metadataVersion = metadataVersion;
            _duplicate.metadataBytes = MessageUtil.duplicate(metadataBytes);
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "Assignor("
                + "name=" + ((name == null) ? "null" : "'" + name.toString() + "'")
                + ", minimumVersion=" + minimumVersion
                + ", maximumVersion=" + maximumVersion
                + ", reason=" + reason
                + ", metadataVersion=" + metadataVersion
                + ", metadataBytes=" + Arrays.toString(metadataBytes)
                + ")";
        }
        
        public String name() {
            return this.name;
        }
        
        public short minimumVersion() {
            return this.minimumVersion;
        }
        
        public short maximumVersion() {
            return this.maximumVersion;
        }
        
        public byte reason() {
            return this.reason;
        }
        
        public short metadataVersion() {
            return this.metadataVersion;
        }
        
        public byte[] metadataBytes() {
            return this.metadataBytes;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public Assignor setName(String v) {
            this.name = v;
            return this;
        }
        
        public Assignor setMinimumVersion(short v) {
            this.minimumVersion = v;
            return this;
        }
        
        public Assignor setMaximumVersion(short v) {
            this.maximumVersion = v;
            return this;
        }
        
        public Assignor setReason(byte v) {
            this.reason = v;
            return this;
        }
        
        public Assignor setMetadataVersion(short v) {
            this.metadataVersion = v;
            return this;
        }
        
        public Assignor setMetadataBytes(byte[] v) {
            this.metadataBytes = v;
            return this;
        }
    }
    
    public static class TopicPartitions implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_0 =
            new Schema(
                new Field("topic_id", Type.UUID, "The topic ID."),
                new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            SCHEMA_0
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        
        public TopicPartitions(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 0;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 0;
        }
        
        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartitions");
            }
            this.topicId = _readable.readUuid();
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(_readable.readInt());
                    }
                    this.partitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(topicId);
            _writable.writeUnsignedVarint(partitions.size() + 1);
            for (Integer partitionsElement : partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartitions");
            }
            _size.addBytes(16);
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitions.size() + 1));
                _size.addBytes(partitions.size() * 4);
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) return false;
            TopicPartitions other = (TopicPartitions) obj;
            if (!this.topicId.equals(other.topicId)) return false;
            if (this.partitions == null) {
                if (other.partitions != null) return false;
            } else {
                if (!this.partitions.equals(other.partitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + topicId.hashCode();
            hashCode = 31 * hashCode + (partitions == null ? 0 : partitions.hashCode());
            return hashCode;
        }
        
        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(partitions.size());
            for (Integer _element : partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "TopicPartitions("
                + "topicId=" + topicId.toString()
                + ", partitions=" + MessageUtil.deepToString(partitions.iterator())
                + ")";
        }
        
        public Uuid topicId() {
            return this.topicId;
        }
        
        public List<Integer> partitions() {
            return this.partitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }
        
        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
}
