/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.kafka.common.network.TransferableChannel;

public class ByteBufferChannel
implements TransferableChannel {
    private final ByteBuffer buf;
    private boolean closed = false;

    public ByteBufferChannel(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size should be not be greater than Integer.MAX_VALUE");
        }
        this.buf = ByteBuffer.allocate((int)size);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int position = this.buf.position();
        int count = offset + length;
        for (int i = offset; i < count; ++i) {
            this.buf.put(srcs[i].duplicate());
        }
        return this.buf.position() - position;
    }

    public long write(ByteBuffer[] srcs) {
        return this.write(srcs, 0, srcs.length);
    }

    public int write(ByteBuffer src) {
        return (int)this.write(new ByteBuffer[]{src});
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() {
        this.buf.flip();
        this.closed = true;
    }

    public ByteBuffer buffer() {
        return this.buf;
    }

    public boolean hasPendingWrites() {
        return false;
    }

    public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
        return fileChannel.transferTo(position, count, (WritableByteChannel)((Object)this));
    }
}

