/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SimpleExampleMessageDataJsonConverter {
    public static SimpleExampleMessageData read(JsonNode _node, short _version) {
        SimpleExampleMessageData _object = new SimpleExampleMessageData();
        JsonNode _processIdNode = _node.get("processId");
        if (_processIdNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'processId', which is mandatory in version " + _version);
            }
            _object.processId = Uuid.ZERO_UUID;
        } else {
            if (!_processIdNode.isTextual()) {
                throw new RuntimeException("SimpleExampleMessageData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.processId = Uuid.fromString((String)_processIdNode.asText());
        }
        JsonNode _myTaggedIntArrayNode = _node.get("myTaggedIntArray");
        if (_myTaggedIntArrayNode == null) {
            _object.myTaggedIntArray = new ArrayList<Integer>(0);
        } else {
            if (!_myTaggedIntArrayNode.isArray()) {
                throw new RuntimeException("SimpleExampleMessageData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_myTaggedIntArrayNode.size());
            _object.myTaggedIntArray = _collection;
            for (JsonNode _element : _myTaggedIntArrayNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"SimpleExampleMessageData element"));
            }
        }
        JsonNode _myNullableStringNode = _node.get("myNullableString");
        if (_myNullableStringNode == null) {
            _object.myNullableString = null;
        } else if (_myNullableStringNode.isNull()) {
            _object.myNullableString = null;
        } else {
            if (!_myNullableStringNode.isTextual()) {
                throw new RuntimeException("SimpleExampleMessageData expected a string type, but got " + _node.getNodeType());
            }
            _object.myNullableString = _myNullableStringNode.asText();
        }
        JsonNode _myInt16Node = _node.get("myInt16");
        _object.myInt16 = _myInt16Node == null ? (short)123 : MessageUtil.jsonNodeToShort((JsonNode)_myInt16Node, (String)"SimpleExampleMessageData");
        JsonNode _myFloat64Node = _node.get("myFloat64");
        _object.myFloat64 = _myFloat64Node == null ? Double.parseDouble("12.34") : MessageUtil.jsonNodeToDouble((JsonNode)_myFloat64Node, (String)"SimpleExampleMessageData");
        JsonNode _myStringNode = _node.get("myString");
        if (_myStringNode == null) {
            _object.myString = "";
        } else {
            if (!_myStringNode.isTextual()) {
                throw new RuntimeException("SimpleExampleMessageData expected a string type, but got " + _node.getNodeType());
            }
            _object.myString = _myStringNode.asText();
        }
        JsonNode _myBytesNode = _node.get("myBytes");
        _object.myBytes = _myBytesNode == null ? Bytes.EMPTY : (byte[])(_myBytesNode.isNull() ? null : MessageUtil.jsonNodeToBinary((JsonNode)_myBytesNode, (String)"SimpleExampleMessageData"));
        JsonNode _taggedUuidNode = _node.get("taggedUuid");
        if (_taggedUuidNode == null) {
            _object.taggedUuid = Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A");
        } else {
            if (!_taggedUuidNode.isTextual()) {
                throw new RuntimeException("SimpleExampleMessageData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.taggedUuid = Uuid.fromString((String)_taggedUuidNode.asText());
        }
        JsonNode _taggedLongNode = _node.get("taggedLong");
        _object.taggedLong = _taggedLongNode == null ? 0xCAFCACAFCACAFCAL : MessageUtil.jsonNodeToLong((JsonNode)_taggedLongNode, (String)"SimpleExampleMessageData");
        JsonNode _zeroCopyByteBufferNode = _node.get("zeroCopyByteBuffer");
        if (_zeroCopyByteBufferNode == null) {
            if (_version >= 1 && _version <= 1) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'zeroCopyByteBuffer', which is mandatory in version " + _version);
            }
            _object.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        } else {
            _object.zeroCopyByteBuffer = ByteBuffer.wrap(MessageUtil.jsonNodeToBinary((JsonNode)_zeroCopyByteBufferNode, (String)"SimpleExampleMessageData"));
        }
        JsonNode _nullableZeroCopyByteBufferNode = _node.get("nullableZeroCopyByteBuffer");
        if (_nullableZeroCopyByteBufferNode == null) {
            if (_version >= 1 && _version <= 1) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'nullableZeroCopyByteBuffer', which is mandatory in version " + _version);
            }
            _object.nullableZeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        } else {
            _object.nullableZeroCopyByteBuffer = _nullableZeroCopyByteBufferNode.isNull() ? null : ByteBuffer.wrap(MessageUtil.jsonNodeToBinary((JsonNode)_nullableZeroCopyByteBufferNode, (String)"SimpleExampleMessageData"));
        }
        JsonNode _myStructNode = _node.get("myStruct");
        if (_myStructNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'myStruct', which is mandatory in version " + _version);
            }
            _object.myStruct = new SimpleExampleMessageData.MyStruct();
        } else {
            _object.myStruct = MyStructJsonConverter.read(_myStructNode, _version);
        }
        JsonNode _myTaggedStructNode = _node.get("myTaggedStruct");
        _object.myTaggedStruct = _myTaggedStructNode == null ? new SimpleExampleMessageData.TaggedStruct() : TaggedStructJsonConverter.read(_myTaggedStructNode, _version);
        JsonNode _myCommonStructNode = _node.get("myCommonStruct");
        if (_myCommonStructNode == null) {
            throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'myCommonStruct', which is mandatory in version " + _version);
        }
        _object.myCommonStruct = TestCommonStructJsonConverter.read(_myCommonStructNode, _version);
        JsonNode _myOtherCommonStructNode = _node.get("myOtherCommonStruct");
        if (_myOtherCommonStructNode == null) {
            throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'myOtherCommonStruct', which is mandatory in version " + _version);
        }
        _object.myOtherCommonStruct = TestCommonStructJsonConverter.read(_myOtherCommonStructNode, _version);
        JsonNode _myUint16Node = _node.get("myUint16");
        if (_myUint16Node == null) {
            if (_version >= 1) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'myUint16', which is mandatory in version " + _version);
            }
            _object.myUint16 = 33000;
        } else {
            _object.myUint16 = MessageUtil.jsonNodeToUnsignedShort((JsonNode)_myUint16Node, (String)"SimpleExampleMessageData");
        }
        JsonNode _myUint32Node = _node.get("myUint32");
        if (_myUint32Node == null) {
            if (_version >= 1) {
                throw new RuntimeException("SimpleExampleMessageData: unable to locate field 'myUint32', which is mandatory in version " + _version);
            }
            _object.myUint32 = 1234567L;
        } else {
            _object.myUint32 = MessageUtil.jsonNodeToUnsignedInt((JsonNode)_myUint32Node, (String)"SimpleExampleMessageData");
        }
        return _object;
    }

    public static JsonNode write(SimpleExampleMessageData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 1) {
            _node.set("processId", (JsonNode)new TextNode(_object.processId.toString()));
        } else if (!_object.processId.equals((Object)Uuid.ZERO_UUID)) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!_object.myTaggedIntArray.isEmpty()) {
                ArrayNode _myTaggedIntArrayArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer _element : _object.myTaggedIntArray) {
                    _myTaggedIntArrayArray.add((JsonNode)new IntNode(_element.intValue()));
                }
                _node.set("myTaggedIntArray", (JsonNode)_myTaggedIntArrayArray);
            }
        } else if (!_object.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (_object.myNullableString != null) {
                _node.set("myNullableString", (JsonNode)new TextNode(_object.myNullableString));
            }
        } else if (_object.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (_object.myInt16 != 123) {
                _node.set("myInt16", (JsonNode)new ShortNode(_object.myInt16));
            }
        } else if (_object.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (_object.myFloat64 != Double.parseDouble("12.34")) {
                _node.set("myFloat64", (JsonNode)new DoubleNode(_object.myFloat64));
            }
        } else if (_object.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!_object.myString.equals("")) {
                _node.set("myString", (JsonNode)new TextNode(_object.myString));
            }
        } else if (!_object.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (_object.myBytes == null || _object.myBytes.length != 0) {
                if (_object.myBytes == null) {
                    _node.set("myBytes", (JsonNode)NullNode.instance);
                } else {
                    _node.set("myBytes", (JsonNode)new BinaryNode(Arrays.copyOf(_object.myBytes, _object.myBytes.length)));
                }
            }
        } else if (_object.myBytes == null || _object.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (!_object.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
                _node.set("taggedUuid", (JsonNode)new TextNode(_object.taggedUuid.toString()));
            }
        } else if (!_object.taggedUuid.equals((Object)Uuid.fromString((String)"H3KKO4NTRPaCWtEmm3vW7A"))) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (_object.taggedLong != 0xCAFCACAFCACAFCAL) {
                _node.set("taggedLong", (JsonNode)new LongNode(_object.taggedLong));
            }
        } else if (_object.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            _node.set("zeroCopyByteBuffer", (JsonNode)new BinaryNode(MessageUtil.byteBufferToArray((ByteBuffer)_object.zeroCopyByteBuffer)));
        } else if (_object.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1 && _version <= 1) {
            if (_object.nullableZeroCopyByteBuffer == null) {
                _node.set("nullableZeroCopyByteBuffer", (JsonNode)NullNode.instance);
            } else {
                _node.set("nullableZeroCopyByteBuffer", (JsonNode)new BinaryNode(MessageUtil.byteBufferToArray((ByteBuffer)_object.nullableZeroCopyByteBuffer)));
            }
        } else if (_object.nullableZeroCopyByteBuffer == null || _object.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 2) {
            _node.set("myStruct", MyStructJsonConverter.write(_object.myStruct, _version, _serializeRecords));
        } else if (!_object.myStruct.equals(new SimpleExampleMessageData.MyStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myStruct at version " + _version);
        }
        if (_version >= 2) {
            if (!_object.myTaggedStruct.equals(new SimpleExampleMessageData.TaggedStruct())) {
                _node.set("myTaggedStruct", TaggedStructJsonConverter.write(_object.myTaggedStruct, _version, _serializeRecords));
            }
        } else if (!_object.myTaggedStruct.equals(new SimpleExampleMessageData.TaggedStruct())) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedStruct at version " + _version);
        }
        _node.set("myCommonStruct", TestCommonStructJsonConverter.write(_object.myCommonStruct, _version, _serializeRecords));
        _node.set("myOtherCommonStruct", TestCommonStructJsonConverter.write(_object.myOtherCommonStruct, _version, _serializeRecords));
        if (_version >= 1) {
            _node.set("myUint16", (JsonNode)new IntNode(_object.myUint16));
        } else if (_object.myUint16 != 33000) {
            throw new UnsupportedVersionException("Attempted to write a non-default myUint16 at version " + _version);
        }
        if (_version >= 1) {
            _node.set("myUint32", (JsonNode)new LongNode(_object.myUint32));
        } else if (_object.myUint32 != 1234567L) {
            throw new UnsupportedVersionException("Attempted to write a non-default myUint32 at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(SimpleExampleMessageData _object, short _version) {
        return SimpleExampleMessageDataJsonConverter.write(_object, _version, true);
    }

    public static class TestCommonStructJsonConverter {
        public static SimpleExampleMessageData.TestCommonStruct read(JsonNode _node, short _version) {
            SimpleExampleMessageData.TestCommonStruct _object = new SimpleExampleMessageData.TestCommonStruct();
            JsonNode _fooNode = _node.get("foo");
            if (_fooNode == null) {
                throw new RuntimeException("TestCommonStruct: unable to locate field 'foo', which is mandatory in version " + _version);
            }
            _object.foo = MessageUtil.jsonNodeToInt((JsonNode)_fooNode, (String)"TestCommonStruct");
            JsonNode _barNode = _node.get("bar");
            if (_barNode == null) {
                throw new RuntimeException("TestCommonStruct: unable to locate field 'bar', which is mandatory in version " + _version);
            }
            _object.bar = MessageUtil.jsonNodeToInt((JsonNode)_barNode, (String)"TestCommonStruct");
            return _object;
        }

        public static JsonNode write(SimpleExampleMessageData.TestCommonStruct _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("foo", (JsonNode)new IntNode(_object.foo));
            _node.set("bar", (JsonNode)new IntNode(_object.bar));
            return _node;
        }

        public static JsonNode write(SimpleExampleMessageData.TestCommonStruct _object, short _version) {
            return TestCommonStructJsonConverter.write(_object, _version, true);
        }
    }

    public static class TaggedStructJsonConverter {
        public static SimpleExampleMessageData.TaggedStruct read(JsonNode _node, short _version) {
            SimpleExampleMessageData.TaggedStruct _object = new SimpleExampleMessageData.TaggedStruct();
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TaggedStruct");
            }
            JsonNode _structIdNode = _node.get("structId");
            if (_structIdNode == null) {
                throw new RuntimeException("TaggedStruct: unable to locate field 'structId', which is mandatory in version " + _version);
            }
            if (!_structIdNode.isTextual()) {
                throw new RuntimeException("TaggedStruct expected a string type, but got " + _node.getNodeType());
            }
            _object.structId = _structIdNode.asText();
            return _object;
        }

        public static JsonNode write(SimpleExampleMessageData.TaggedStruct _object, short _version, boolean _serializeRecords) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TaggedStruct");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("structId", (JsonNode)new TextNode(_object.structId));
            return _node;
        }

        public static JsonNode write(SimpleExampleMessageData.TaggedStruct _object, short _version) {
            return TaggedStructJsonConverter.write(_object, _version, true);
        }
    }

    public static class StructArrayJsonConverter {
        public static SimpleExampleMessageData.StructArray read(JsonNode _node, short _version) {
            SimpleExampleMessageData.StructArray _object = new SimpleExampleMessageData.StructArray();
            JsonNode _arrayFieldIdNode = _node.get("arrayFieldId");
            if (_arrayFieldIdNode == null) {
                throw new RuntimeException("StructArray: unable to locate field 'arrayFieldId', which is mandatory in version " + _version);
            }
            _object.arrayFieldId = MessageUtil.jsonNodeToInt((JsonNode)_arrayFieldIdNode, (String)"StructArray");
            return _object;
        }

        public static JsonNode write(SimpleExampleMessageData.StructArray _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("arrayFieldId", (JsonNode)new IntNode(_object.arrayFieldId));
            return _node;
        }

        public static JsonNode write(SimpleExampleMessageData.StructArray _object, short _version) {
            return StructArrayJsonConverter.write(_object, _version, true);
        }
    }

    public static class MyStructJsonConverter {
        public static SimpleExampleMessageData.MyStruct read(JsonNode _node, short _version) {
            SimpleExampleMessageData.MyStruct _object = new SimpleExampleMessageData.MyStruct();
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MyStruct");
            }
            JsonNode _structIdNode = _node.get("structId");
            if (_structIdNode == null) {
                throw new RuntimeException("MyStruct: unable to locate field 'structId', which is mandatory in version " + _version);
            }
            _object.structId = MessageUtil.jsonNodeToInt((JsonNode)_structIdNode, (String)"MyStruct");
            JsonNode _arrayInStructNode = _node.get("arrayInStruct");
            if (_arrayInStructNode == null) {
                throw new RuntimeException("MyStruct: unable to locate field 'arrayInStruct', which is mandatory in version " + _version);
            }
            if (!_arrayInStructNode.isArray()) {
                throw new RuntimeException("MyStruct expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<SimpleExampleMessageData.StructArray> _collection = new ArrayList<SimpleExampleMessageData.StructArray>(_arrayInStructNode.size());
            _object.arrayInStruct = _collection;
            for (JsonNode _element : _arrayInStructNode) {
                _collection.add(StructArrayJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(SimpleExampleMessageData.MyStruct _object, short _version, boolean _serializeRecords) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MyStruct");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("structId", (JsonNode)new IntNode(_object.structId));
            ArrayNode _arrayInStructArray = new ArrayNode(JsonNodeFactory.instance);
            for (SimpleExampleMessageData.StructArray _element : _object.arrayInStruct) {
                _arrayInStructArray.add(StructArrayJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("arrayInStruct", (JsonNode)_arrayInStructArray);
            return _node;
        }

        public static JsonNode write(SimpleExampleMessageData.MyStruct _object, short _version) {
            return MyStructJsonConverter.write(_object, _version, true);
        }
    }
}

