/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConsumerConfigTest {
    private final Deserializer<byte[]> keyDeserializer = new ByteArrayDeserializer();
    private final Deserializer<String> valueDeserializer = new StringDeserializer();
    private final String keyDeserializerClassName = this.keyDeserializer.getClass().getName();
    private final String valueDeserializerClassName = this.valueDeserializer.getClass().getName();
    private final Object keyDeserializerClass = this.keyDeserializer.getClass();
    private final Object valueDeserializerClass = this.valueDeserializer.getClass();
    private final Properties properties = new Properties();

    @BeforeEach
    public void setUp() {
        this.properties.setProperty("key.deserializer", this.keyDeserializerClassName);
        this.properties.setProperty("value.deserializer", this.valueDeserializerClassName);
    }

    @Test
    public void testOverrideClientId() {
        this.properties.setProperty("group.id", "test-group");
        ConsumerConfig config = new ConsumerConfig(this.properties);
        Assertions.assertFalse((boolean)config.getString("client.id").isEmpty());
    }

    @Test
    public void testOverrideEnableAutoCommit() {
        ConsumerConfig config = new ConsumerConfig(this.properties);
        boolean overrideEnableAutoCommit = config.maybeOverrideEnableAutoCommit();
        Assertions.assertFalse((boolean)overrideEnableAutoCommit);
        this.properties.setProperty("enable.auto.commit", "true");
        config = new ConsumerConfig(this.properties);
        try {
            config.maybeOverrideEnableAutoCommit();
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testAppendDeserializerToConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        Map newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, null);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("value.deserializer", this.valueDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, null);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        configs.put("key.deserializer", this.keyDeserializerClass);
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, null, this.valueDeserializer);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
        configs.clear();
        newConfigs = ConsumerConfig.appendDeserializerToConfig(configs, this.keyDeserializer, this.valueDeserializer);
        Assertions.assertEquals(newConfigs.get("key.deserializer"), (Object)this.keyDeserializerClass);
        Assertions.assertEquals(newConfigs.get("value.deserializer"), (Object)this.valueDeserializerClass);
    }

    @Test
    public void testAppendDeserializerToConfigWithException() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", null);
        configs.put("value.deserializer", this.valueDeserializerClass);
        Assertions.assertThrows(ConfigException.class, () -> ConsumerConfig.appendDeserializerToConfig((Map)configs, null, this.valueDeserializer));
        configs.clear();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", null);
        Assertions.assertThrows(ConfigException.class, () -> ConsumerConfig.appendDeserializerToConfig((Map)configs, this.keyDeserializer, null));
    }

    @Test
    public void ensureDefaultThrowOnUnsupportedStableFlagToFalse() {
        Assertions.assertFalse((boolean)new ConsumerConfig(this.properties).getBoolean("internal.throw.on.fetch.stable.offset.unsupported"));
    }

    @Test
    public void testDefaultPartitionAssignor() {
        Assertions.assertEquals(Arrays.asList(RangeAssignor.class, CooperativeStickyAssignor.class), (Object)new ConsumerConfig(this.properties).getList("partition.assignment.strategy"));
    }

    @Test
    public void testInvalidGroupInstanceId() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("group.instance.id", "");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("group.instance.id"));
    }

    @Test
    public void testInvalidSecurityProtocol() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.deserializer", this.keyDeserializerClass);
        configs.put("value.deserializer", this.valueDeserializerClass);
        configs.put("security.protocol", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ConsumerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }
}

