/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LegacyRecordTest {
    private final byte magic;
    private final long timestamp;
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final CompressionType compression;
    private final TimestampType timestampType;
    private final LegacyRecord record;

    public LegacyRecordTest(byte magic, long timestamp, byte[] key, byte[] value, CompressionType compression) {
        this.magic = magic;
        this.timestamp = timestamp;
        this.timestampType = TimestampType.CREATE_TIME;
        this.key = key == null ? null : ByteBuffer.wrap(key);
        this.value = value == null ? null : ByteBuffer.wrap(value);
        this.compression = compression;
        this.record = LegacyRecord.create((byte)magic, (long)timestamp, (byte[])key, (byte[])value, (CompressionType)compression, (TimestampType)this.timestampType);
    }

    @Test
    public void testFields() {
        Assert.assertEquals((Object)this.compression, (Object)this.record.compressionType());
        Assert.assertEquals((Object)(this.key != null ? 1 : 0), (Object)this.record.hasKey());
        Assert.assertEquals((Object)this.key, (Object)this.record.key());
        if (this.key != null) {
            Assert.assertEquals((long)this.key.limit(), (long)this.record.keySize());
        }
        Assert.assertEquals((long)this.magic, (long)this.record.magic());
        Assert.assertEquals((Object)this.value, (Object)this.record.value());
        if (this.value != null) {
            Assert.assertEquals((long)this.value.limit(), (long)this.record.valueSize());
        }
        if (this.magic > 0) {
            Assert.assertEquals((long)this.timestamp, (long)this.record.timestamp());
            Assert.assertEquals((Object)this.timestampType, (Object)this.record.timestampType());
        } else {
            Assert.assertEquals((long)-1L, (long)this.record.timestamp());
            Assert.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)this.record.timestampType());
        }
    }

    @Test
    public void testChecksum() {
        Assert.assertEquals((long)this.record.checksum(), (long)this.record.computeChecksum());
        byte attributes = LegacyRecord.computeAttributes((byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME);
        Assert.assertEquals((long)this.record.checksum(), (long)LegacyRecord.computeChecksum((byte)this.magic, (byte)attributes, (long)this.timestamp, (byte[])(this.key == null ? null : this.key.array()), this.value == null ? null : this.value.array()));
        Assert.assertTrue((boolean)this.record.isValid());
        for (int i = 4; i < this.record.sizeInBytes(); ++i) {
            LegacyRecord copy = this.copyOf(this.record);
            copy.buffer().put(i, (byte)69);
            Assert.assertFalse((boolean)copy.isValid());
            try {
                copy.ensureValid();
                Assert.fail((String)"Should fail the above test.");
                continue;
            }
            catch (InvalidRecordException e) {
                // empty catch block
            }
        }
    }

    private LegacyRecord copyOf(LegacyRecord record) {
        ByteBuffer buffer = ByteBuffer.allocate(record.sizeInBytes());
        record.buffer().put(buffer);
        buffer.rewind();
        record.buffer().rewind();
        return new LegacyRecord(buffer);
    }

    @Test
    public void testEquality() {
        Assert.assertEquals((Object)this.record, (Object)this.copyOf(this.record));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        byte[] payload = new byte[1000];
        Arrays.fill(payload, (byte)1);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (byte magic : Arrays.asList((byte)0, (byte)1)) {
            for (long timestamp : Arrays.asList(-1L, 0L, 1L)) {
                for (byte[] key : Arrays.asList(null, "".getBytes(), "key".getBytes(), payload)) {
                    for (byte[] value : Arrays.asList(null, "".getBytes(), "value".getBytes(), payload)) {
                        for (CompressionType compression : CompressionType.values()) {
                            values.add(new Object[]{magic, timestamp, key, value, compression});
                        }
                    }
                }
            }
        }
        return values;
    }
}

