/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.rmi.remote.RemoteLockManager;
import org.apache.jackrabbit.rmi.remote.RemoteNamespaceRegistry;
import org.apache.jackrabbit.rmi.remote.RemoteNodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteObservationManager;
import org.apache.jackrabbit.rmi.remote.RemoteQueryManager;
import org.apache.jackrabbit.rmi.remote.RemoteVersionManager;
import org.apache.jackrabbit.rmi.remote.RemoteWorkspace;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerWorkspace
extends ServerObject
implements RemoteWorkspace {
    private Workspace workspace;
    private RemoteObservationManager remoteObservationManager;
    private RemoteLockManager remoteLockManager;
    private RemoteVersionManager remoteVersionManager;

    public ServerWorkspace(Workspace workspace, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.workspace = workspace;
    }

    @Override
    public String getName() throws RemoteException {
        return this.workspace.getName();
    }

    @Override
    public void copy(String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.copy(from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void copy(String workspace, String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.copy(workspace, from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void clone(String workspace, String from, String to, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.workspace.clone(workspace, from, to, removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void move(String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.move(from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteNodeTypeManager getNodeTypeManager() throws RepositoryException, RemoteException {
        try {
            NodeTypeManager manager = this.workspace.getNodeTypeManager();
            return this.getFactory().getRemoteNodeTypeManager(manager);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteNamespaceRegistry getNamespaceRegistry() throws RepositoryException, RemoteException {
        try {
            NamespaceRegistry registry = this.workspace.getNamespaceRegistry();
            return this.getFactory().getRemoteNamespaceRegistry(registry);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteQueryManager getQueryManager() throws RepositoryException, RemoteException {
        try {
            QueryManager queryManager = this.workspace.getQueryManager();
            return this.getFactory().getRemoteQueryManager(this.workspace.getSession(), queryManager);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteObservationManager getObservationManager() throws RepositoryException, RemoteException {
        try {
            if (this.remoteObservationManager == null) {
                ObservationManager observationManager = this.workspace.getObservationManager();
                this.remoteObservationManager = this.getFactory().getRemoteObservationManager(observationManager);
            }
            return this.remoteObservationManager;
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public String[] getAccessibleWorkspaceNames() throws RepositoryException, RemoteException {
        try {
            return this.workspace.getAccessibleWorkspaceNames();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void importXML(String path, byte[] xml, int uuidBehaviour) throws IOException, RepositoryException, RemoteException {
        try {
            this.workspace.importXML(path, (InputStream)new ByteArrayInputStream(xml), uuidBehaviour);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void createWorkspace(String name, String source) throws RepositoryException, RemoteException {
        if (source != null) {
            this.workspace.createWorkspace(name, source);
        } else {
            this.workspace.createWorkspace(name);
        }
    }

    @Override
    public void deleteWorkspace(String name) throws RepositoryException, RemoteException {
        this.workspace.deleteWorkspace(name);
    }

    @Override
    public RemoteLockManager getLockManager() throws RepositoryException, RemoteException {
        try {
            if (this.remoteLockManager == null) {
                LockManager lockManager = this.workspace.getLockManager();
                this.remoteLockManager = this.getFactory().getRemoteLockManager(lockManager);
            }
            return this.remoteLockManager;
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteVersionManager getVersionManager() throws RepositoryException, RemoteException {
        try {
            if (this.remoteVersionManager == null) {
                VersionManager versionManager = this.workspace.getVersionManager();
                this.remoteVersionManager = this.getFactory().getRemoteVersionManager(this.workspace.getSession(), versionManager);
            }
            return this.remoteVersionManager;
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

