/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyUnionObjectInspector
implements UnionObjectInspector {
    public static final Log LOG = LogFactory.getLog((String)LazyUnionObjectInspector.class.getName());
    private List<ObjectInspector> ois;
    private byte separator;
    private Text nullSequence;
    private boolean escaped;
    private byte escapeChar;

    protected LazyUnionObjectInspector() {
    }

    protected LazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        this.init(ois, separator, nullSequence, escaped, escapeChar);
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName(this);
    }

    protected void init(List<ObjectInspector> ois, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.escaped = escaped;
        this.escapeChar = escapeChar;
        this.ois = new ArrayList<ObjectInspector>();
        this.ois.addAll(ois);
    }

    protected LazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, Text nullSequence) {
        this.init(ois, separator, nullSequence);
    }

    protected void init(List<ObjectInspector> ois, byte separator, Text nullSequence) {
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.ois = new ArrayList<ObjectInspector>();
        this.ois.addAll(ois);
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.nullSequence;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public Object getField(Object data) {
        if (data == null) {
            return null;
        }
        return ((LazyUnion)data).getField();
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    @Override
    public byte getTag(Object data) {
        if (data == null) {
            return -1;
        }
        return ((LazyUnion)data).getTag();
    }
}

