/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.factories.CalmMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.NoKillMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ServerKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.SlowDeterministicMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.StressAssignmentManagerMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.UnbalanceMonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;

public abstract class MonkeyFactory {
    protected String tableName;
    protected Set<String> columnFamilies;
    protected IntegrationTestingUtility util;
    protected Properties properties = new Properties();
    public static final String CALM = "calm";
    public static final String SLOW_DETERMINISTIC = "slowDeterministic";
    public static final String UNBALANCE = "unbalance";
    public static final String SERVER_KILLING = "serverKilling";
    public static final String STRESS_AM = "stressAM";
    public static final String NO_KILL = "noKill";
    public static Map<String, MonkeyFactory> FACTORIES = ImmutableMap.builder().put((Object)"calm", (Object)new CalmMonkeyFactory()).put((Object)"slowDeterministic", (Object)new SlowDeterministicMonkeyFactory()).put((Object)"unbalance", (Object)new UnbalanceMonkeyFactory()).put((Object)"serverKilling", (Object)new ServerKillingMonkeyFactory()).put((Object)"stressAM", (Object)new StressAssignmentManagerMonkeyFactory()).put((Object)"noKill", (Object)new NoKillMonkeyFactory()).build();

    public MonkeyFactory setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public MonkeyFactory setColumnFamilies(Set<String> columnFamilies) {
        this.columnFamilies = columnFamilies;
        return this;
    }

    public MonkeyFactory setUtil(IntegrationTestingUtility util) {
        this.util = util;
        return this;
    }

    public MonkeyFactory setProperties(Properties props) {
        if (props != null) {
            this.properties = props;
        }
        return this;
    }

    public abstract ChaosMonkey build();

    public static MonkeyFactory getFactory(String factoryName) {
        return FACTORIES.get(factoryName);
    }
}

