/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class CompactRandomRegionOfTableAction
extends Action {
    private final byte[] tableNameBytes;
    private final int majorRatio;
    private final long sleepTime;
    private final String tableName;

    public CompactRandomRegionOfTableAction(String tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactRandomRegionOfTableAction(int sleepTime, String tableName, float majorRatio) {
        this.tableNameBytes = Bytes.toBytes((String)tableName);
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        boolean major = RandomUtils.nextInt((int)100) < this.majorRatio;
        LOG.info((Object)("Performing action: Compact random region of table " + this.tableName + ", major=" + major));
        List regions = admin.getTableRegions(this.tableNameBytes);
        if (regions == null || regions.isEmpty()) {
            LOG.info((Object)("Table " + this.tableName + " doesn't have regions to compact"));
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        try {
            if (major) {
                LOG.debug((Object)("Major compacting region " + region.getRegionNameAsString()));
                admin.majorCompact(region.getRegionName());
            } else {
                LOG.debug((Object)("Compacting region " + region.getRegionNameAsString()));
                admin.compact(region.getRegionName());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Compaction failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

