/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpConfig {
    private static boolean sslEnabled;

    @VisibleForTesting
    static void setSecure(boolean secure) {
        sslEnabled = secure;
    }

    public static boolean isSecure() {
        return sslEnabled;
    }

    public static String getSchemePrefix() {
        return HttpConfig.isSecure() ? "https://" : "http://";
    }

    static {
        Configuration conf = new Configuration();
        sslEnabled = conf.getBoolean("hadoop.ssl.enabled", false);
    }
}

