/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(UuidSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    private static boolean isHex(byte b) {
        return b > 0 && StringTools.ALPHA_DIGIT[b];
    }

    public UuidSyntaxChecker() {
        super("1.3.6.1.1.16.1");
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!(value instanceof String)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        byte[] b = ((String)value).getBytes();
        if (b.length < 36) {
            return false;
        }
        if (UuidSyntaxChecker.isHex(b[0]) && UuidSyntaxChecker.isHex(b[1]) && UuidSyntaxChecker.isHex(b[2]) && UuidSyntaxChecker.isHex(b[3]) & UuidSyntaxChecker.isHex(b[4]) && UuidSyntaxChecker.isHex(b[5]) && UuidSyntaxChecker.isHex(b[6]) && UuidSyntaxChecker.isHex(b[7]) & b[8] == 45 & UuidSyntaxChecker.isHex(b[9]) && UuidSyntaxChecker.isHex(b[10]) && UuidSyntaxChecker.isHex(b[11]) && UuidSyntaxChecker.isHex(b[12]) & b[13] == 45 & UuidSyntaxChecker.isHex(b[14]) && UuidSyntaxChecker.isHex(b[15]) && UuidSyntaxChecker.isHex(b[16]) && UuidSyntaxChecker.isHex(b[17]) & b[18] == 45 & UuidSyntaxChecker.isHex(b[19]) && UuidSyntaxChecker.isHex(b[20]) && UuidSyntaxChecker.isHex(b[21]) && UuidSyntaxChecker.isHex(b[22]) & b[23] == 45 & UuidSyntaxChecker.isHex(b[24]) && UuidSyntaxChecker.isHex(b[25]) && UuidSyntaxChecker.isHex(b[26]) && UuidSyntaxChecker.isHex(b[27]) & UuidSyntaxChecker.isHex(b[28]) && UuidSyntaxChecker.isHex(b[29]) && UuidSyntaxChecker.isHex(b[30]) && UuidSyntaxChecker.isHex(b[31]) & UuidSyntaxChecker.isHex(b[32]) && UuidSyntaxChecker.isHex(b[33]) && UuidSyntaxChecker.isHex(b[34]) && UuidSyntaxChecker.isHex(b[35])) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

