/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import com.wordnik.swagger.jaxrs.config.BeanConfig;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import java.util.ArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;

public class SwaggerFeature
extends AbstractFeature {
    private String resourcePackage;
    private String version = "1.0.0";
    private String basePath;
    private String title = "Rest sample app";
    private String description = "This is a app.";
    private String contact = "freeman.fang@gmail.com";
    private String license = "Apache 2.0 License";
    private String licenseUrl = "http://www.apache.org/licenses/LICENSE-2.0.html";
    private boolean scan = true;

    public void initialize(Server server, Bus bus) {
        ArrayList<ApiListingResourceJSON> serviceBeans = new ArrayList<ApiListingResourceJSON>();
        serviceBeans.add(new ApiListingResourceJSON());
        this.calulateDefaultResourcePackage(server);
        this.calulateDefaultBasePath(server);
        ((JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName())).setResourceClassesFromBeans(serviceBeans);
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new ResourceListingProvider());
        providers.add(new ApiDeclarationProvider());
        ((ProviderFactory)bus.getProperty(ProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setScan(this.isScan());
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
    }

    private void calulateDefaultResourcePackage(Server server) {
        JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        AbstractResourceInfo resourceInfo = (AbstractResourceInfo)serviceFactoryBean.getClassResourceInfo().get(0);
        if (resourceInfo != null && (this.getResourcePackage() == null || this.getResourcePackage().length() == 0)) {
            this.setResourcePackage(resourceInfo.getResourceClass().getPackage().getName());
        }
    }

    private void calulateDefaultBasePath(Server server) {
        String address = server.getEndpoint().getEndpointInfo().getAddress();
        this.setBasePath(address + "/api-docs");
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }
}

