/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityUtils {
    public static final String X509_KEY = "X509_KEY";
    public static final String X509_ISSUER_SERIAL = "X509_ISSUER_SERIAL";

    private SecurityUtils() {
    }

    public static X509Certificate loadX509Certificate(Crypto crypto, Element certNode) throws Exception {
        String base64Value = certNode.getTextContent().trim();
        byte[] certBytes = Base64Utility.decode((String)base64Value);
        return crypto.loadCertificate((InputStream)new ByteArrayInputStream(certBytes));
    }

    public static X509Certificate loadX509IssuerSerial(Crypto crypto, Element certNode) throws Exception {
        Node issuerNameNode = certNode.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName").item(0);
        Node serialNumberNode = certNode.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber").item(0);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
        cryptoType.setIssuerSerial(issuerNameNode.getTextContent(), new BigInteger(serialNumberNode.getTextContent()));
        return crypto.getX509Certificates(cryptoType)[0];
    }

    public static X509Certificate[] getCertificates(Crypto crypto, String user) throws WSSecurityException {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(user);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null || issuerCerts.length == 0) {
            throw new WSSecurityException("No issuer certs were found using issuer name: " + user);
        }
        return issuerCerts;
    }

    public static Crypto getCrypto(Message message, String cryptoKey, String propKey) throws IOException, WSSecurityException {
        return new CryptoLoader().getCrypto(message, cryptoKey, propKey);
    }

    public static String getUserName(Message message, Crypto crypto, String userNameKey) {
        String user = (String)message.getContextualProperty(userNameKey);
        if (crypto != null && StringUtils.isEmpty((String)user)) {
            try {
                user = crypto.getDefaultX509Identifier();
            }
            catch (WSSecurityException e1) {
                throw new Fault((Throwable)e1);
            }
        }
        return user;
    }

    public static String getPassword(Message message, String userName, int type, Class<?> callingClass) {
        CallbackHandler handler = SecurityUtils.getCallbackHandler(message, callingClass);
        if (handler == null) {
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, type)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            return null;
        }
        String password = cb[0].getPassword();
        return password == null ? "" : password;
    }

    public static CallbackHandler getCallbackHandler(Message message, Class<?> callingClass) {
        return SecurityUtils.getCallbackHandler(message, callingClass, "ws-security.callback-handler");
    }

    public static CallbackHandler getCallbackHandler(Message message, Class<?> callingClass, String callbackProperty) {
        Object o = message.getContextualProperty(callbackProperty);
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), callingClass).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }
}

