/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;

public class TypeCache {
    private final String repositoryId;
    private final CmisService service;
    private final Map<String, TypeDefinition> typeDefinitions;

    public TypeCache(String repositoryId, CmisService service) {
        this.repositoryId = repositoryId;
        this.service = service;
        this.typeDefinitions = new HashMap<String, TypeDefinition>();
    }

    public TypeDefinition getTypeDefinition(String typeId) {
        TypeDefinition type = this.typeDefinitions.get(typeId);
        if (type == null && (type = this.service.getTypeDefinition(this.repositoryId, typeId, null)) != null) {
            this.typeDefinitions.put(type.getId(), type);
        }
        return type;
    }

    public TypeDefinition getTypeDefinitionForObject(String objectId) {
        ObjectInfo info = this.service.getObjectInfo(this.repositoryId, objectId);
        if (info == null) {
            return null;
        }
        return this.getTypeDefinition(info.getTypeId());
    }
}

