/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;

public class AutoSavingRowCache<K extends DecoratedKey, V>
extends AutoSavingCache<K, V> {
    public AutoSavingRowCache(ICache<K, V> cache, String tableName, String cfName) {
        super(cache, tableName, cfName, ColumnFamilyStore.CacheType.ROW_CACHE_TYPE);
    }

    @Override
    public double getConfiguredCacheSize(CFMetaData cfm) {
        return cfm == null ? 0.0 : cfm.getRowCacheSize();
    }

    @Override
    public ByteBuffer translateKey(K key) {
        return ((DecoratedKey)key).key;
    }
}

