/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.SpringUtils;
import org.andromda.cartridges.spring.metafacades.SpringEntity;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.cartridges.spring.metafacades.SpringQueryOperationLogic;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.StringUtils;

public class SpringQueryOperationLogicImpl
extends SpringQueryOperationLogic {
    private static final long serialVersionUID = 34L;
    private String translatedQuery = null;
    private static final String USE_NAMED_PARAMETERS = "hibernateQueryUseNamedParameters";

    public SpringQueryOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetQuery() {
        return this.getQuery((SpringEntity)null);
    }

    private String getTranslatedQuery() {
        if (this.translatedQuery == null) {
            this.translatedQuery = super.getQuery("query.Hibernate-QL");
        }
        return this.translatedQuery;
    }

    @Override
    protected boolean handleIsUseNamedParameters() {
        boolean useNamedParameters = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(USE_NAMED_PARAMETERS))) != false || StringUtils.isNotBlank((String)this.getTranslatedQuery());
        return SpringMetafacadeUtils.getUseNamedParameters((OperationFacade)this, useNamedParameters);
    }

    @Override
    protected boolean handleIsCriteriaFinder() {
        return this.getCriteriaArgument() != null;
    }

    @Override
    protected ParameterFacade handleGetCriteriaArgument() {
        ParameterFacade foundParameter = null;
        for (ParameterFacade parameter : this.getParameters()) {
            ClassifierFacade type = parameter.getType();
            if (type == null || !type.hasStereotype(UMLProfile.STEREOTYPE_CRITERIA)) continue;
            foundParameter = parameter;
            break;
        }
        return foundParameter;
    }

    @Override
    protected String handleGetQuery(SpringEntity entity) {
        Object value;
        String queryString = this.getTranslatedQuery();
        if (StringUtils.isBlank((String)queryString) && (queryString = (String)(value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_QUERY))) != null) {
            queryString = queryString.replaceAll("[$\\s]+", " ");
        }
        if (StringUtils.isBlank((String)queryString)) {
            SpringEntity owner = null;
            String entityName = null;
            if (entity == null) {
                owner = this.getOwner();
                entityName = owner.getFullyQualifiedName();
            } else {
                owner = entity;
                entityName = entity.getFullyQualifiedEntityImplementationName();
            }
            String variableName = StringUtils.uncapitalize((String)owner.getName());
            queryString = "from " + entityName + " as " + variableName;
            if (!this.getArguments().isEmpty()) {
                queryString = queryString + " where";
                Collection<ParameterFacade> arguments = this.getArguments();
                Iterator<ParameterFacade> iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    ParameterFacade argument = iterator.next();
                    ClassifierFacade type = argument.getType();
                    if (type == null) continue;
                    String parameterName = argument.getName();
                    if (type.isEmbeddedValue()) {
                        Iterator attributeIterator = type.getAttributes(true).iterator();
                        while (attributeIterator.hasNext()) {
                            AttributeFacade attribute = (AttributeFacade)attributeIterator.next();
                            String parameter = "?";
                            if (this.isUseNamedParameters()) {
                                parameter = ':' + SpringUtils.concatNamesCamelCase(Arrays.asList(parameterName, attribute.getName()));
                            }
                            queryString = queryString + ' ' + variableName + '.' + parameterName + '.' + attribute.getName() + " = " + parameter;
                            if (!attributeIterator.hasNext()) continue;
                            queryString = queryString + " and";
                        }
                        continue;
                    }
                    String parameter = "?";
                    if (this.isUseNamedParameters()) {
                        parameter = ':' + parameterName;
                    }
                    queryString = queryString + ' ' + variableName + '.' + parameterName + " = " + parameter;
                    if (!iterator.hasNext()) continue;
                    queryString = queryString + " and";
                }
            }
        }
        return queryString;
    }
}

