/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring;

public class SpringHibernateUtils {
    private String hibernateVersion = "3";
    private String hibernateXmlPersistence;
    private String hibernateMappingStrategy;

    public void setHibernateVersion(String hibernateVersionIn) {
        this.hibernateVersion = hibernateVersionIn;
    }

    public String getBasePackage() {
        return this.isVersion3() || this.isVersion4() ? "org.hibernate" : "net.sf.hibernate";
    }

    public String getCriterionPackage() {
        return this.getBasePackage() + (this.isVersion3() || this.isVersion4() ? ".criterion" : ".expression");
    }

    public String getRestrictionClass() {
        return this.getCriterionPackage() + (this.isVersion3() || this.isVersion4() ? ".Restrictions" : ".Expression");
    }

    public String getSpringHibernatePackage() {
        return this.isVersion3() ? "org.springframework.orm.hibernate3" : (this.isVersion4() ? "org.springframework.orm.hibernate3" : "org.springframework.orm.hibernate");
    }

    public String getEagerFetchMode() {
        return this.isVersion3() || this.isVersion4() ? "JOIN" : "EAGER";
    }

    public String getDisjunctionClassName() {
        return this.getCriterionPackage() + (this.isVersion3() || this.isVersion4() ? ".Restrictions" : ".Expression");
    }

    public boolean isVersion2() {
        return SpringHibernateUtils.isVersion2(this.hibernateVersion);
    }

    public boolean isVersion3() {
        return SpringHibernateUtils.isVersion3(this.hibernateVersion);
    }

    public boolean isVersion4() {
        return SpringHibernateUtils.isVersion4(this.hibernateVersion);
    }

    public static boolean isVersion2(String hibernateVersionPropertyValue) {
        return hibernateVersionPropertyValue.startsWith("2");
    }

    public static boolean isVersion3(String hibernateVersionPropertyValue) {
        return hibernateVersionPropertyValue.startsWith("3");
    }

    public static boolean isVersion4(String hibernateVersionPropertyValue) {
        return hibernateVersionPropertyValue.startsWith("4");
    }

    public void setHibernateXMLPersistence(String hibernateXmlPersistenceIn) {
        this.hibernateXmlPersistence = hibernateXmlPersistenceIn;
    }

    public boolean isXmlPersistenceActive() {
        return SpringHibernateUtils.isXmlPersistenceActive(this.hibernateVersion, this.hibernateXmlPersistence);
    }

    public static boolean isXmlPersistenceActive(String hibernateVersionPropertyValue, String hibernateXMLPersistencePropertyValue) {
        return SpringHibernateUtils.isVersion3(hibernateVersionPropertyValue) && "true".equalsIgnoreCase(hibernateXMLPersistencePropertyValue);
    }

    public void setHibernateMappingStrategy(String hibernateMappingStrategyIn) {
        this.hibernateMappingStrategy = hibernateMappingStrategyIn;
    }

    public boolean isMapSubclassesInSeparateFile() {
        return SpringHibernateUtils.mapSubclassesInSeparateFile(this.hibernateMappingStrategy);
    }

    public static boolean mapSubclassesInSeparateFile(String hibernateMappingStrategyIn) {
        return "subclass".equalsIgnoreCase(hibernateMappingStrategyIn);
    }
}

