/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import nl.geodienstencentrum.maven.plugin.sass.compiler.CompilerCallback;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.io.IOUtil;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

public abstract class AbstractSassMojo
extends AbstractMojo {
    private static final String BOURBON_GEM_PATH = "core";
    private static final String BOURBON_DEST_PATH = "bourbon";
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/css")
    protected File destination;
    @Parameter(defaultValue="true")
    protected boolean failOnError;
    @Parameter
    private Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));
    @Parameter
    private List<Resource> resources = Collections.emptyList();
    @Parameter(defaultValue="${project.build.directory}/rubygems")
    private String[] gemPaths = new String[0];
    @Parameter
    private String[] gems = new String[0];
    @Parameter(defaultValue="false")
    private boolean useBourbon;
    @Parameter(defaultValue="${basedir}/src/main/sass", property="sassSourceDirectory")
    private File sassSourceDirectory;
    @Parameter
    private String[] includes = new String[]{"**/*.scss"};
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="..")
    private String relativeOutputDirectory;
    @Parameter(defaultValue="false")
    private boolean skip;

    protected void executeSassScript(String sassScript) throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        Log log = this.getLog();
        log.debug((CharSequence)("Execute Sass Ruby script:\n\n" + sassScript + "\n\n"));
        ScriptingContainer scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
        CompilerCallback compilerCallback = new CompilerCallback(log);
        scriptingContainer.setHomeDirectory("uri:classloader://META-INF/jruby.home");
        scriptingContainer.put("$compiler_callback", (Object)compilerCallback);
        Object o = scriptingContainer.runScriptlet(sassScript);
        if (this.failOnError && compilerCallback.hadError()) {
            throw new MojoFailureException("Sass compilation encountered errors (see above for details).");
        }
        log.debug((CharSequence)"\n");
        scriptingContainer.terminate();
    }

    protected void buildBasicSassScript(StringBuilder sassScript) throws MojoExecutionException {
        Log log = this.getLog();
        sassScript.append("require 'rubygems'\n");
        if (this.gemPaths.length > 0) {
            sassScript.append("env = { 'GEM_PATH' => [\n");
            for (String gemPath2 : this.gemPaths) {
                sassScript.append("    '").append(gemPath2).append("',\n");
            }
            String gemPath = System.getenv("GEM_PATH");
            if (gemPath != null) {
                String[] stringArray = gemPath.split(File.pathSeparator);
                int n = stringArray.length;
                for (int gemPath2 = 0; gemPath2 < n; ++gemPath2) {
                    String p = stringArray[gemPath2];
                    sassScript.append("    '").append(p).append("',\n");
                }
            }
            sassScript.setLength(sassScript.length() - 2);
            sassScript.append("\n].uniq.join(File::PATH_SEPARATOR) }\n");
            sassScript.append("Gem.paths = env\n");
        }
        for (String gem : this.gems) {
            sassScript.append("require '").append(gem).append("'\n");
        }
        sassScript.append("require 'sass/plugin'\n");
        sassScript.append("require 'java'\n");
        Iterator<Map.Entry<String, String>> templateLocations = this.getTemplateLocations();
        if (templateLocations.hasNext()) {
            Map.Entry<String, String> location = templateLocations.next();
            this.sassOptions.put("template_location", "'" + location.getKey() + "'");
            this.sassOptions.put("css_location", "'" + location.getValue() + "'");
        }
        if (!this.sassOptions.containsKey("cache_location")) {
            File sassCacheDir = new File(this.buildDirectory, "sass_cache");
            String sassCacheDirStr = sassCacheDir.toString();
            this.sassOptions.put("cache_location", "'" + FilenameUtils.separatorsToUnix((String)sassCacheDirStr) + "'");
        }
        sassScript.append("Sass::Plugin.options.merge!(\n");
        Iterator<Map.Entry<String, String>> entryItr = this.sassOptions.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, String> optEntry = entryItr.next();
            String opt = optEntry.getKey();
            String value = optEntry.getValue();
            sassScript.append("    :").append(opt).append(" => ").append(value);
            if (entryItr.hasNext()) {
                sassScript.append(",");
            }
            sassScript.append('\n');
        }
        sassScript.append(")\n");
        while (templateLocations.hasNext()) {
            Map.Entry<String, String> location = templateLocations.next();
            sassScript.append("Sass::Plugin.add_template_location('").append(location.getKey()).append("', '").append(location.getValue()).append("')\n");
        }
        if (this.useBourbon) {
            log.info((CharSequence)"Running with Bourbon enabled.");
            String bDest = this.buildDirectory + "/bourbon-lib";
            this.extractBourbonResources(bDest);
            sassScript.append("Sass::Plugin.add_template_location('").append(bDest).append("', '").append(this.destination).append("')\n");
        }
        sassScript.append("Sass::Plugin.on_compilation_error {|error, template, css| $compiler_callback.compilationError(error.message, template, css) }\n");
        sassScript.append("Sass::Plugin.on_updated_stylesheet {|template, css| $compiler_callback.updatedStylesheeet(template, css) }\n");
        sassScript.append("Sass::Plugin.on_template_modified {|template| $compiler_callback.templateModified(template) }\n");
        sassScript.append("Sass::Plugin.on_template_created {|template| $compiler_callback.templateCreated(template) }\n");
        sassScript.append("Sass::Plugin.on_template_deleted {|template| $compiler_callback.templateDeleted(template) }\n");
        if (log.isDebugEnabled()) {
            sassScript.append("require 'pp'\n");
            sassScript.append("pp Sass::Plugin.options\n");
        }
    }

    private Iterator<Map.Entry<String, String>> getTemplateLocations() {
        Log log = this.getLog();
        ImmutableList resList = this.resources;
        if (resList.isEmpty()) {
            log.info((CharSequence)"No resource element was specified, using short configuration.");
            Resource resource = new Resource();
            resource.source = new FileSet();
            if (this.sassSourceDirectory != null) {
                log.debug((CharSequence)("Setting source directory: " + this.sassSourceDirectory.toString()));
                resource.source.setDirectory(this.sassSourceDirectory.toString());
            } else {
                log.error((CharSequence)("\"" + this.sassSourceDirectory + "\" is not a directory."));
                resource.source.setDirectory("./src/main/sass");
            }
            if (this.includes != null) {
                log.debug((CharSequence)("Setting includes: " + Arrays.toString(this.includes)));
                resource.source.setIncludes(Arrays.asList(this.includes));
            }
            if (this.excludes != null) {
                log.debug((CharSequence)("Setting excludes: " + Arrays.toString(this.excludes)));
                resource.source.setExcludes(Arrays.asList(this.excludes));
            }
            resource.relativeOutputDirectory = this.relativeOutputDirectory;
            resource.destination = this.destination;
            resList = ImmutableList.of((Object)resource);
        }
        ArrayList<Map.Entry<String, String>> locations = new ArrayList<Map.Entry<String, String>>();
        for (Resource source : resList) {
            for (Map.Entry<String, String> entry : source.getDirectoriesAndDestinations(log).entrySet()) {
                log.info((CharSequence)("Queueing Sass template for compile: " + entry.getKey() + " => " + entry.getValue()));
                locations.add(entry);
            }
        }
        return locations.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void extractBourbonResources(String destinationDir) {
        Log log = this.getLog();
        try {
            File destDir = new File(destinationDir);
            if (destDir.isDirectory()) {
                log.info((CharSequence)"Bourbon resources seems to have been extracted before.");
                return;
            }
            log.info((CharSequence)("Extracting Bourbon resources to: " + destinationDir));
            destDir.mkdirs();
            URL urlJar = ((Object)((Object)this)).getClass().getClassLoader().getResource("scss-report.xsl");
            String resourceFilePath = urlJar.getFile();
            int index = resourceFilePath.indexOf("!");
            String jarFileURI = resourceFilePath.substring(0, index);
            File jarFile = new File(new URI(jarFileURI));
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enums = jar.entries();
            while (enums.hasMoreElements()) {
                JarEntry entry = enums.nextElement();
                if (!entry.getName().contains(BOURBON_GEM_PATH) && !entry.getName().contains("_bourbon.scss")) continue;
                index = entry.getName().indexOf(BOURBON_GEM_PATH);
                String fileName = destinationDir + File.separator + entry.getName().substring(index);
                File f = new File(fileName.replace(BOURBON_GEM_PATH, BOURBON_DEST_PATH));
                if (fileName.endsWith("/")) {
                    log.debug((CharSequence)("create Bourbon directory: " + f));
                    f.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(f);
                try {
                    IOUtil.copy((InputStream)jar.getInputStream(entry), (OutputStream)fos);
                }
                finally {
                    IOUtil.close((OutputStream)fos);
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            log.error((CharSequence)"Error extracting Bourbon resources.", (Throwable)ex);
        }
    }

    protected List<Resource> getResources() {
        return this.resources;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected File getSassSourceDirectory() {
        return this.sassSourceDirectory;
    }
}

