/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.security;

import java.io.File;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.FFMQSecurityException;
import net.timewalker.ffmq4.security.SecurityConnector;
import net.timewalker.ffmq4.security.SecurityContext;
import net.timewalker.ffmq4.security.User;
import net.timewalker.ffmq4.security.XMLSecurityDescriptor;
import net.timewalker.ffmq4.security.XMLSecurityDescriptorHandler;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.xml.XMLDescriptorReader;

public final class XMLSecurityConnector
implements SecurityConnector {
    public static final String DEFAULT_SECURITY_FILE = "../conf/security.xml";
    private XMLSecurityDescriptor descriptor;

    public XMLSecurityConnector(Settings settings) throws JMSException {
        String securityDescriptorFilePath = settings.getStringProperty("security.connector.xml.securityFile", DEFAULT_SECURITY_FILE);
        File securityDescriptorFile = new File(securityDescriptorFilePath);
        if (!securityDescriptorFile.canRead()) {
            throw new FFMQException("Cannot access security descriptor file : " + securityDescriptorFile.getAbsolutePath(), "FS_ERROR");
        }
        this.descriptor = (XMLSecurityDescriptor)new XMLDescriptorReader().read(securityDescriptorFile, XMLSecurityDescriptorHandler.class);
        this.descriptor.check();
    }

    public SecurityContext getContext(String userName, String password) throws FFMQSecurityException {
        if (userName == null) {
            throw new FFMQSecurityException("User name not specified", "INVALID_SECURITY_DESCRIPTOR");
        }
        User user = this.descriptor.getUser(userName);
        if (user == null || !user.getPassword().equals(password)) {
            throw new FFMQSecurityException("Invalid user/password", "INVALID_SECURITY_DESCRIPTOR");
        }
        return user;
    }
}

