/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.listeners.tcp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.timewalker.ffmq4.jmx.JMXAgent;
import net.timewalker.ffmq4.listeners.AbstractClientListener;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.utils.Settings;

public abstract class AbstractTcpClientListener
extends AbstractClientListener {
    protected static final int DEFAULT_TCP_BACK_LOG = 50;
    protected String listenAddr;
    protected int listenPort;
    protected int listenerCapacity;

    public AbstractTcpClientListener(FFMQEngine localEngine, Settings settings, JMXAgent jmxAgent, String listenAddr, int listenPort) {
        super(localEngine, settings, jmxAgent);
        this.listenAddr = listenAddr;
        this.listenPort = listenPort;
        this.listenerCapacity = settings.getIntProperty("listener.tcp.capacity", 200);
    }

    @Override
    public int getCapacity() {
        return this.listenerCapacity;
    }

    protected InetAddress getBindAddress() throws UnknownHostException {
        if (this.listenAddr == null || this.listenAddr.equalsIgnoreCase("auto")) {
            return InetAddress.getLocalHost();
        }
        return InetAddress.getByName(this.listenAddr);
    }
}

