/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.timewalker.ffmq4.jmx.JMXAgent;
import net.timewalker.ffmq4.listeners.ClientListener;
import net.timewalker.ffmq4.listeners.ClientProcessor;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.utils.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractClientListener
implements ClientListener {
    private static final Log log = LogFactory.getLog(AbstractClientListener.class);
    protected FFMQEngine localEngine;
    protected Settings settings;
    protected JMXAgent jmxAgent;
    private List<ClientProcessor> clientList = new Vector<ClientProcessor>();
    protected int acceptedClients;
    private int droppedClients;
    private int maxActiveClients;
    protected boolean started;

    public AbstractClientListener(FFMQEngine localEngine, Settings settings, JMXAgent jmxAgent) {
        this.localEngine = localEngine;
        this.settings = settings;
        this.jmxAgent = jmxAgent;
    }

    @Override
    public String getEngineName() {
        return this.localEngine.getName();
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClient(ClientProcessor processor) {
        List<ClientProcessor> list = this.clientList;
        synchronized (list) {
            this.clientList.add(processor);
            ++this.acceptedClients;
            if (this.clientList.size() > this.maxActiveClients) {
                this.maxActiveClients = this.clientList.size();
            }
            if (this.jmxAgent != null) {
                try {
                    this.jmxAgent.register(this.createProcessorName(processor), processor);
                }
                catch (Exception e) {
                    log.error((Object)"Could not register client in JMX agent", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClient(ClientProcessor processor) {
        List<ClientProcessor> list = this.clientList;
        synchronized (list) {
            this.clientList.remove(processor);
            ++this.droppedClients;
            if (this.jmxAgent != null) {
                try {
                    this.jmxAgent.unregister(this.createProcessorName(processor));
                }
                catch (Exception e) {
                    log.error((Object)"Could not unregister client from JMX agent", (Throwable)e);
                }
            }
        }
    }

    private ObjectName createProcessorName(ClientProcessor processor) throws MalformedObjectNameException {
        return new ObjectName("FFMQ:type=Listeners,listener=" + this.getName() + ",children=clients,id=" + processor.getClientID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRemainingClients() {
        ArrayList<ClientProcessor> clientsToStop = new ArrayList<ClientProcessor>();
        List<ClientProcessor> list = this.clientList;
        synchronized (list) {
            clientsToStop.addAll(this.clientList);
        }
        for (ClientProcessor clientProcessor : clientsToStop) {
            clientProcessor.stop();
        }
        this.clientList.clear();
    }

    @Override
    public int getActiveClients() {
        return this.clientList.size();
    }

    @Override
    public int getAcceptedTotal() {
        return this.acceptedClients;
    }

    @Override
    public int getDroppedTotal() {
        return this.droppedClients;
    }

    @Override
    public int getMaxActiveClients() {
        return this.maxActiveClients;
    }

    @Override
    public void resetStats() {
        this.acceptedClients = 0;
        this.droppedClients = 0;
        this.maxActiveClients = 0;
    }
}

