/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.client;

import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import net.thucydides.plugins.jira.client.CouldNotLocateServiceException;
import thucydides.plugins.jira.soap.JiraSoapService;
import thucydides.plugins.jira.soap.JiraSoapServiceService;
import thucydides.plugins.jira.soap.JiraSoapServiceServiceLocator;

public class SOAPSession {
    private JiraSoapServiceService jiraSoapServiceLocator;
    private JiraSoapService jiraSoapService;
    private String token;

    public static SOAPSession openConnectionTo(URL webServicePort) {
        return new SOAPSession(webServicePort);
    }

    protected JiraSoapServiceService getServiceLocator() {
        if (this.jiraSoapServiceLocator == null) {
            this.jiraSoapServiceLocator = new JiraSoapServiceServiceLocator();
        }
        return this.jiraSoapServiceLocator;
    }

    protected SOAPSession(URL webServicePort) {
        try {
            this.jiraSoapService = this.getServiceLocator().getJirasoapserviceV2(webServicePort);
        }
        catch (ServiceException e) {
            throw new CouldNotLocateServiceException("ServiceException during SOAPClient contruction", e);
        }
    }

    public SOAPSession usingCredentials(String userName, String password) throws RemoteException {
        this.token = this.getJiraSoapService().login(userName, password);
        return this;
    }

    public String getAuthenticationToken() {
        return this.token;
    }

    public JiraSoapService getJiraSoapService() {
        return this.jiraSoapService;
    }
}

