/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener2;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.BuiltInRuleSet;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

public class RuleTraceListener
implements TraceListener2 {
    String sourceId;
    String xslId;
    int repeat = 0;
    HashMap<Mode, HashMap<Object, RuleTrace>> rules = new HashMap();
    Logger out = new StandardLogger();
    private Configuration config = null;
    private long initialStart = 0L;
    private long startTime;
    private static String typeChars = "EATW  PCD   N";

    public void setXslId(String xslId) {
        this.xslId = xslId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public void setOutputDestination(Logger stream) {
        this.out = stream;
    }

    public void open(Controller controller) {
        this.config = controller.getConfiguration();
    }

    public void startRuleSearch() {
        this.startTime = System.nanoTime();
        if (this.initialStart == 0L) {
            this.initialStart = this.startTime;
        }
    }

    public void endRuleSearch(Object rule, Mode mode, Item item) {
        RuleTrace details;
        long duration = System.nanoTime() - this.startTime;
        HashMap<Object, RuleTrace> thisModeRules = this.rules.get(mode);
        if (thisModeRules == null) {
            thisModeRules = new HashMap();
            this.rules.put(mode, thisModeRules);
        }
        if ((details = thisModeRules.get(rule)) == null) {
            details = rule instanceof BuiltInRuleSet ? new BuiltInRuleTrace() : new RuleTrace();
            thisModeRules.put(rule, details);
        }
        details.add(duration, item);
    }

    public void close() {
        long overallTime = System.nanoTime() - this.initialStart;
        try {
            Receiver rec = null;
            rec = ExpressionPresenter.defaultDestination(this.config, this.out);
            StreamWriterToReceiver writer = new StreamWriterToReceiver(rec);
            writer.writeStartDocument();
            writer.writeStartElement("statsRTL");
            writer.writeAttribute("total.time", "" + overallTime);
            writer.writeAttribute("dateTime", DateTimeValue.getCurrentDateTime(null).getPrimitiveStringValue().toString());
            if (this.sourceId != null) {
                writer.writeAttribute("s", this.sourceId);
            }
            if (this.xslId != null) {
                writer.writeAttribute("xsl", this.xslId);
            }
            if (this.repeat != 0) {
                writer.writeAttribute("repeat", "" + this.repeat);
            }
            writer.writeStartElement("config");
            String label = this.config.getLabel();
            if (label != null) {
                writer.writeAttribute("label", label);
            }
            writer.writeAttribute("edition", this.config.getEditionCode());
            writer.writeAttribute("version", Version.getProductVersion());
            this.config.getDefaultXsltCompilerInfo().getPatternOptimization().write(writer);
            writer.writeEndElement();
            for (Mode mode : this.rules.keySet()) {
                writer.writeStartElement("mode");
                writer.writeAttribute("name", "" + mode.getModeName().getDisplayName().replace("saxon:_defaultMode", "#default"));
                HashMap<Object, RuleTrace> thisModeRules = this.rules.get(mode);
                writer.writeAttribute("count", "" + thisModeRules.size());
                for (Object r : thisModeRules.keySet()) {
                    int[] hist;
                    writer.writeStartElement("rule");
                    RuleTrace trace = thisModeRules.get(r);
                    List<Long> times = trace.times;
                    Collections.sort(times);
                    int size = times.size();
                    writer.writeAttribute("count", "" + size);
                    long sum = 0L;
                    long min = Long.MAX_VALUE;
                    long max = 0L;
                    long var = 0L;
                    for (Long ti : times) {
                        sum += ti.longValue();
                        min = Math.min(min, ti);
                        max = Math.max(min, ti);
                    }
                    long mean = sum / (long)size;
                    for (Long ti : times) {
                        long diff = mean - ti;
                        var += diff * diff;
                    }
                    var /= (long)size;
                    long lowerDecile = times.get(size / 10);
                    long upperDecile = times.get(9 * size / 10);
                    long upper20th = times.get(19 * size / 20);
                    writer.writeAttribute("total", "" + sum);
                    writer.writeAttribute("min", "" + min);
                    writer.writeAttribute("l10", "" + lowerDecile);
                    writer.writeAttribute("avg", "" + mean);
                    writer.writeAttribute("std", "" + (long)Math.sqrt(var));
                    writer.writeAttribute("med", "" + times.get(size / 2));
                    writer.writeAttribute("h10", "" + upperDecile);
                    writer.writeAttribute("h20", "" + upper20th);
                    writer.writeAttribute("max", "" + max);
                    if (r instanceof Rule) {
                        Rule rule = (Rule)r;
                        TemplateRule t = (TemplateRule)rule.getAction();
                        String f = t.getSystemId();
                        writer.writeAttribute("loc", (String)f + "#" + t.getLineNumber());
                        writer.writeAttribute("seq", "" + rule.getSequence());
                        writer.writeAttribute("rank", "" + rule.getRank());
                    } else if (r instanceof BuiltInRuleSet) {
                        writer.writeAttribute("built-in", mode.getCodeForBuiltInRuleSet((BuiltInRuleSet)r));
                        String res = "";
                        hist = new int[14];
                        for (Integer b : ((BuiltInRuleTrace)trace).type) {
                            int n = b - 1;
                            hist[n] = hist[n] + 1;
                        }
                        for (int i = 0; i < hist.length; ++i) {
                            if (hist[i] <= 0) continue;
                            res = res + " " + typeChars.charAt(i) + ":" + hist[i];
                        }
                        writer.writeAttribute("types", res.substring(1));
                    }
                    int nBins = 10;
                    if (size > 300) {
                        hist = new int[nBins + 2];
                        long d = (upper20th - min) / (long)nBins;
                        for (Long t : times) {
                            int bin = (int)((t - min) / d);
                            if (t >= upper20th) continue;
                            int n = bin;
                            hist[n] = hist[n] + 1;
                        }
                        String res = "";
                        for (int b : hist) {
                            res = res + " " + b;
                        }
                        writer.writeAttribute("hist", res.substring(1));
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XPathException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void enter(InstructionInfo instruction, XPathContext context) {
    }

    public void leave(InstructionInfo instruction) {
    }

    public void startCurrentItem(Item currentItem) {
    }

    public void endCurrentItem(Item currentItem) {
    }

    private class BuiltInRuleTrace
    extends RuleTrace {
        public List<Integer> type;

        BuiltInRuleTrace() {
            this.type = new ArrayList<Integer>();
        }

        void add(long duration, Item item) {
            this.add(duration);
            if (item instanceof NodeInfo) {
                this.type.add(((NodeInfo)item).getNodeKind());
            }
        }
    }

    private class RuleTrace {
        public List<Long> times = new ArrayList<Long>(200);
        public List<Integer> type;

        RuleTrace() {
        }

        void add(long duration, Item item) {
            this.add(duration);
        }

        void add(long duration) {
            this.times.add(duration);
        }
    }
}

