/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Arrays;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.trace.ExpressionPresenter;

public class StylesheetSpaceStrippingRule
implements SpaceStrippingRule {
    private static final int[] specials = new int[]{131, 132, 133, 136, 138, 141, 142, 153, 169, 172, 177, 178, 199, 202};
    private NamePool namePool;

    public StylesheetSpaceStrippingRule(NamePool pool) {
        this.namePool = pool;
    }

    public byte isSpacePreserving(NodeName elementName) {
        int fingerprint;
        if (!elementName.hasFingerprint()) {
            elementName.allocateNameCode(this.namePool);
        }
        if ((fingerprint = elementName.getFingerprint()) == 201) {
            return 1;
        }
        if (Arrays.binarySearch(specials, fingerprint) >= 0) {
            return 2;
        }
        return 0;
    }

    public void export(ExpressionPresenter presenter) {
    }
}

