/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupToBeSorted;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class SortedGroupIterator
extends SortedIterator
implements GroupIterator {
    int groupSlot = -1;
    int keySlot = -1;

    private SortedGroupIterator() {
    }

    public SortedGroupIterator(XPathContext context, GroupIterator base, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] comparators) {
        super(context, base, sortKeyEvaluator, comparators, true);
        this.setHostLanguage(50);
    }

    protected void buildArray() throws XPathException {
        Item item;
        int allocated = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)((Object)this.base)).getLength() : 100;
        this.values = new GroupToBeSorted[allocated];
        this.count = 0;
        XPathContextMajor c2 = this.context.newContext();
        c2.setCurrentIterator((FocusIterator)this.base);
        GroupIterator groupIter = (GroupIterator)((FocusTrackingIterator)this.base).getUnderlyingIterator();
        c2.setCurrentGroupIterator(groupIter);
        while ((item = this.base.next()) != null) {
            if (this.count == allocated) {
                GroupToBeSorted[] nk2 = new GroupToBeSorted[allocated *= 2];
                System.arraycopy((GroupToBeSorted[])this.values, 0, nk2, 0, this.count);
                this.values = nk2;
            }
            GroupToBeSorted gtbs = new GroupToBeSorted(this.comparators.length);
            this.values[this.count] = gtbs;
            gtbs.value = item;
            for (int n = 0; n < this.comparators.length; ++n) {
                gtbs.sortKeyValues[n] = this.sortKeyEvaluator.evaluateSortKey(n, c2);
            }
            ++this.count;
            gtbs.originalPosition = gtbs.originalPosition;
            gtbs.currentGroupingKey = groupIter.getCurrentGroupingKey();
            gtbs.currentGroupIterator = groupIter.iterateCurrentGroup();
        }
    }

    public Item next() throws XPathException {
        Item next = super.next();
        if (next != null) {
            if (this.groupSlot >= 0) {
                this.context.setLocalVariable(this.groupSlot, new SequenceExtent(((GroupToBeSorted)this.values[this.position - 1]).currentGroupIterator.getAnother()));
            }
            if (this.keySlot >= 0) {
                this.context.setLocalVariable(this.keySlot, ((GroupToBeSorted)this.values[this.position - 1]).currentGroupingKey);
            }
        }
        return next;
    }

    public AtomicSequence getCurrentGroupingKey() {
        return ((GroupToBeSorted)this.values[this.position - 1]).currentGroupingKey;
    }

    public SequenceIterator iterateCurrentGroup() throws XPathException {
        SequenceIterator iter = ((GroupToBeSorted)this.values[this.position - 1]).currentGroupIterator;
        return iter.getAnother();
    }

    public boolean hasCurrentGroup() {
        return this.groupSlot < 0;
    }

    public boolean hasCurrentGroupingKey() {
        return this.keySlot < 0;
    }

    public SortedGroupIterator getAnother() throws XPathException {
        return (SortedGroupIterator)this.initializeAnother(new SortedGroupIterator());
    }
}

