/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ComponentCode;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedTemplate
extends ComponentCode<NamedTemplate> {
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean mayOmitContextItem = true;
    private boolean maySupplyContextItem = true;

    public void setTemplateName(StructuredQName templateName) {
        this.templateName = templateName;
    }

    public void setContextItemRequirements(ItemType type, boolean mayBeOmitted, boolean mayBeSupplied) {
        this.requiredContextItemType = type;
        this.mayOmitContextItem = mayBeOmitted;
        this.maySupplyContextItem = mayBeSupplied;
    }

    @Override
    public int getComponentKind() {
        return 200;
    }

    @Override
    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    @Override
    public void setBody(Expression body) {
        super.setBody(body);
        this.bodyIsTailCallReturner = body instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public boolean isMayOmitContextItem() {
        return this.mayOmitContextItem;
    }

    public boolean isMaySupplyContextItem() {
        return this.maySupplyContextItem;
    }

    public List<LocalParam> getLocalParams() {
        ArrayList<LocalParam> result = new ArrayList<LocalParam>();
        NamedTemplate.gatherLocalParams(this.getInterpretedBody(), result);
        return result;
    }

    private static void gatherLocalParams(Expression exp, List<LocalParam> result) {
        if (exp instanceof LocalParamSetter) {
            result.add(((LocalParamSetter)exp).getBinding());
        } else {
            for (Operand o : exp.operands()) {
                NamedTemplate.gatherLocalParams(o.getChildExpression(), result);
            }
        }
    }

    public LocalParam getLocalParam(StructuredQName id) {
        for (Operand o : this.body.operands()) {
            LocalParam lp;
            Expression child = o.getChildExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child) || (lp = NamedTemplate.getLocalParam(child, id)) == null) continue;
            return lp;
        }
        return null;
    }

    private static LocalParam getLocalParam(Expression exp, StructuredQName id) {
        for (Operand o : exp.operands()) {
            Expression child = o.getChildExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child)) continue;
            return NamedTemplate.getLocalParam(child, id);
        }
        return null;
    }

    public TailCall expand(XPathContext context) throws XPathException {
        Item contextItem = context.getContextItem();
        if (contextItem == null) {
            if (!this.mayOmitContextItem) {
                XPathException err = new XPathException("The template requires a context item, but none has been supplied", "XTTE3090");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        } else {
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            if (this.requiredContextItemType != AnyItemType.getInstance() && !this.requiredContextItemType.matches(contextItem, th)) {
                XPathException err = new XPathException("The template requires a context item of type " + this.requiredContextItemType + ", but the supplied context item has type " + Type.getItemType(contextItem, context.getConfiguration().getTypeHierarchy()), "XTTE0590");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
            if (!this.maySupplyContextItem) {
                context = context.newMinorContext();
                context.setCurrentIterator(null);
            }
        }
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
        }
        if (this.body != null) {
            this.body.process(context);
        }
        return null;
    }

    @Override
    public int getConstructType() {
        return 2008;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("template");
        presenter.emitAttribute("name", this.getTemplateName().getEQName());
        this.explainProperties(presenter);
        presenter.emitAttribute("slots", "" + this.getStackFrameMap().getNumberOfVariables());
        if (this.getBody() != null) {
            presenter.setChildRole("body");
            this.getBody().export(presenter);
        }
        presenter.endElement();
    }

    public void explainProperties(ExpressionPresenter presenter) {
        if (this.getRequiredContextItemType() != AnyItemType.getInstance()) {
            presenter.emitAttribute("cxt", this.getRequiredContextItemType().toString());
        }
        String flags = "";
        if (this.mayOmitContextItem) {
            flags = "o";
        }
        if (this.maySupplyContextItem) {
            flags = flags + "s";
        }
        presenter.emitAttribute("flags", flags);
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            presenter.emitAttribute("as", this.getRequiredType().toString());
        }
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
    }

    public Expression getInterpretedBody() {
        Expression original = this.body;
        return original;
    }
}

