/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyTemplates
extends Instruction
implements ITemplateCall,
ComponentInvocation {
    private Operand selectOp;
    private WithParam[] actualParams;
    private WithParam[] tunnelParams;
    protected boolean useCurrentMode = false;
    protected boolean useTailRecursion = false;
    protected Mode mode;
    protected boolean implicitSelect;
    protected boolean inStreamableConstruct = false;
    protected RuleManager ruleManager;
    private int bindingSlot;

    protected ApplyTemplates() {
    }

    public ApplyTemplates(Expression select, boolean useCurrentMode, boolean useTailRecursion, boolean implicitSelect, boolean inStreamableConstruct, Mode mode, RuleManager ruleManager) {
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.init(select, useCurrentMode, useTailRecursion, mode);
        this.implicitSelect = implicitSelect;
        this.inStreamableConstruct = inStreamableConstruct;
        this.ruleManager = ruleManager;
    }

    protected void init(Expression select, boolean useCurrentMode, boolean useTailRecursion, Mode mode) {
        this.setSelect(select);
        this.useCurrentMode = useCurrentMode;
        this.useTailRecursion = useTailRecursion;
        this.mode = mode;
        this.adoptChildExpression(select);
    }

    public void setMode(SimpleMode target) {
        this.mode = target;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    public void setActualParams(WithParam[] params) {
        this.actualParams = params;
    }

    public void setTunnelParams(WithParam[] params) {
        this.tunnelParams = params;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> operanda = new ArrayList<Operand>();
        operanda.add(this.selectOp);
        WithParam.gatherOperands(this, this.getActualParams(), operanda);
        WithParam.gatherOperands(this, this.getTunnelParams(), operanda);
        return operanda;
    }

    @Override
    public int getInstructionNameCode() {
        return 133;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    @Override
    public Expression simplify() throws XPathException {
        WithParam.simplify(this.getActualParams());
        WithParam.simplify(this.getTunnelParams());
        this.setSelect(this.getSelect().simplify());
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextInfo);
        WithParam.typeCheck(this.tunnelParams, visitor, contextInfo);
        try {
            this.selectOp.typeCheck(visitor, contextInfo);
        }
        catch (XPathException e) {
            if (this.implicitSelect) {
                String code = e.getErrorCodeLocalPart();
                if ("XPTY0020".equals(code) || "XPTY0019".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is an atomic value");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
                if ("XPDY0002".equals(code)) {
                    XPathException err = new XPathException("Cannot apply-templates to child nodes when the context item is absent");
                    err.setErrorCode("XTTE0510");
                    err.setIsTypeError(true);
                    throw err;
                }
            }
            throw e;
        }
        this.adoptChildExpression(this.getSelect());
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextInfo);
        WithParam.optimize(visitor, this.tunnelParams, contextInfo);
        this.selectOp.typeCheck(visitor, contextInfo);
        this.selectOp.optimize(visitor, contextInfo);
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return super.getIntrinsicDependencies() | (this.useCurrentMode ? 1 : 0);
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    @Override
    public Expression copy() {
        ApplyTemplates a2 = new ApplyTemplates(this.getSelect().copy(), this.useCurrentMode, this.useTailRecursion, this.implicitSelect, this.inStreamableConstruct, this.mode, this.ruleManager);
        a2.setActualParams(WithParam.copy(a2, this.getActualParams()));
        a2.setTunnelParams(WithParam.copy(a2, this.getTunnelParams()));
        ExpressionTool.copyLocationInfo(this, a2);
        a2.ruleManager = this.ruleManager;
        return a2;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        this.apply(context, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return this.apply(context, this.useTailRecursion);
    }

    protected TailCall apply(XPathContext context, boolean returnTailCall) throws XPathException {
        Component<? extends Mode> targetMode = this.getTargetMode(context);
        Mode thisMode = targetMode.getCode();
        ParameterSet params = ApplyTemplates.assembleParams(context, this.getActualParams());
        ParameterSet tunnels = ApplyTemplates.assembleTunnelParams(context, this.getTunnelParams());
        if (returnTailCall) {
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.getSelect(), context, 1), targetMode, params, tunnels, c2, this.getLocation());
        }
        SequenceIterator iter = this.getSelect().iterate(context);
        if (iter instanceof EmptyIterator) {
            return null;
        }
        XPathContextMajor c2 = context.newContext();
        c2.setCurrentIterator(new FocusTrackingIterator(iter));
        c2.setCurrentMode(targetMode);
        c2.setOrigin(this);
        c2.setCurrentComponent(targetMode);
        if (this.inStreamableConstruct) {
            c2.setCurrentGroupIterator(null);
        }
        try {
            for (TailCall tc = thisMode.applyTemplates(params, tunnels, c2, this.getLocation()); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (StackOverflowError e) {
            XPathException err = new XPathException("Too many nested apply-templates calls. The stylesheet may be looping.");
            err.setErrorCode("SXLM0001");
            err.setLocation(this.getLocation());
            err.setXPathContext(context);
            throw err;
        }
        return null;
    }

    public Component<? extends Mode> getTargetMode(XPathContext context) {
        Component targetMode;
        if (this.useCurrentMode) {
            targetMode = context.getCurrentMode();
        } else if (this.bindingSlot >= 0) {
            targetMode = context.getTargetComponent(this.bindingSlot);
            if (targetMode.getVisibility() == Visibility.ABSTRACT) {
                throw new AssertionError((Object)"Modes cannot be abstract");
            }
        } else {
            targetMode = this.mode.getDeclaringComponent();
        }
        return targetMode;
    }

    public Expression getSelectExpression() {
        return this.getSelect();
    }

    public boolean isImplicitSelect() {
        return this.implicitSelect;
    }

    public boolean useTailRecursion() {
        return this.useTailRecursion;
    }

    public boolean usesCurrentMode() {
        return this.useCurrentMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Component getFixedTarget() {
        return this.mode.getDeclaringComponent();
    }

    @Override
    public SymbolicName getSymbolicName() {
        return this.mode == null ? null : this.mode.getSymbolicName();
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        this.setSelect(this.doPromotion(this.getSelect(), offer));
        WithParam.promoteParams(this.actualParams, offer);
        WithParam.promoteParams(this.tunnelParams, offer);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("applyT", this);
        if (this.mode != null && !this.mode.isUnnamedMode()) {
            out.emitAttribute("mode", this.mode.getModeName().getEQName());
        }
        String flags = "";
        if (this.useCurrentMode) {
            flags = "c";
        }
        if (this.useTailRecursion) {
            flags = flags + "t";
        }
        if (this.implicitSelect) {
            flags = flags + "i";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        out.emitAttribute("bSlot", "" + this.getBindingSlot());
        out.setChildRole("select");
        this.getSelect().export(out);
        if (this.getActualParams().length != 0) {
            WithParam.exportParameters(this.getActualParams(), out, false);
        }
        if (this.getTunnelParams().length != 0) {
            WithParam.exportParameters(this.getTunnelParams(), out, true);
        }
        out.endElement();
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    @Override
    public void setBindingSlot(int slot) {
        this.bindingSlot = slot;
    }

    @Override
    public int getBindingSlot() {
        return this.bindingSlot;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ApplyTemplatesPackage
    implements TailCall {
        private Sequence selectedItems;
        private Component<? extends Mode> targetMode;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContextMajor evaluationContext;
        private Location locationId;

        ApplyTemplatesPackage(Sequence selectedItems, Component<? extends Mode> targetMode, ParameterSet params, ParameterSet tunnelParams, XPathContextMajor context, Location locationId) {
            this.selectedItems = selectedItems;
            this.targetMode = targetMode;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = context;
            this.locationId = locationId;
        }

        @Override
        public TailCall processLeavingTail() throws XPathException {
            this.evaluationContext.setCurrentIterator(new FocusTrackingIterator(this.selectedItems.iterate()));
            this.evaluationContext.setCurrentMode(this.targetMode);
            this.evaluationContext.setCurrentComponent(this.targetMode);
            return this.targetMode.getCode().applyTemplates(this.params, this.tunnelParams, this.evaluationContext, this.locationId);
        }
    }
}

