/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.Version;
import net.sf.saxon.expr.AnalyzeMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeString
extends Instruction
implements ContextOriginator {
    private Operand selectOp;
    private Operand regexOp;
    private Operand flagsOp;
    private Operand matchingOp;
    private Operand nonMatchingOp;
    private static final OperandRole ACTION = new OperandRole(6, OperandUsage.NAVIGATION);
    private RegularExpression pattern;
    private boolean useXsltErrorCodes = true;

    public AnalyzeString(Expression select, Expression regex, Expression flags, Expression matching, Expression nonMatching, RegularExpression pattern) {
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.regexOp = new Operand(this, regex, OperandRole.SINGLE_ATOMIC);
        this.flagsOp = new Operand(this, flags, OperandRole.SINGLE_ATOMIC);
        if (matching != null) {
            this.matchingOp = new Operand(this, matching, ACTION);
        }
        if (nonMatching != null) {
            this.nonMatchingOp = new Operand(this, nonMatching, ACTION);
        }
        this.pattern = pattern;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getRegex() {
        return this.regexOp.getChildExpression();
    }

    public void setRegex(Expression regex) {
        this.regexOp.setChildExpression(regex);
    }

    public Expression getFlags() {
        return this.flagsOp.getChildExpression();
    }

    public void setFlags(Expression flags) {
        this.flagsOp.setChildExpression(flags);
    }

    public Expression getMatching() {
        return this.matchingOp == null ? null : this.matchingOp.getChildExpression();
    }

    public void setMatching(Expression matching) {
        if (this.matchingOp != null) {
            this.matchingOp.setChildExpression(matching);
        } else {
            this.matchingOp = new Operand(this, matching, ACTION);
        }
    }

    public Expression getNonMatching() {
        return this.nonMatchingOp == null ? null : this.nonMatchingOp.getChildExpression();
    }

    public void setNonMatching(Expression nonMatching) {
        if (this.nonMatchingOp != null) {
            this.nonMatchingOp.setChildExpression(nonMatching);
        } else {
            this.nonMatchingOp = new Operand(this, nonMatching, ACTION);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 131;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.selectOp, this.regexOp, this.flagsOp, this.matchingOp, this.nonMatchingOp);
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    public RegularExpression getPatternExpression() {
        return this.pattern;
    }

    public boolean isAllow30features() {
        return this.getRetainedStaticContext().getXPathVersion() >= 30;
    }

    public void setUseXsltErrorCodes(boolean xslt) {
        this.useXsltErrorCodes = xslt;
    }

    public boolean isUseXsltErrorCodes() {
        return this.useXsltErrorCodes;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.selectOp.typeCheck(visitor, contextInfo);
        this.regexOp.typeCheck(visitor, contextInfo);
        this.flagsOp.typeCheck(visitor, contextInfo);
        if (this.matchingOp != null) {
            this.matchingOp.typeCheck(visitor, new ContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        if (this.nonMatchingOp != null) {
            this.nonMatchingOp.typeCheck(visitor, new ContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        RoleDiagnostic role = new RoleDiagnostic(4, "analyze-string/select", 0);
        SequenceType required = visitor.getStaticContext().getXPathVersion() >= 30 ? SequenceType.OPTIONAL_STRING : SequenceType.SINGLE_STRING;
        this.setSelect(TypeChecker.staticTypeCheck(this.getSelect(), required, false, role, visitor));
        role = new RoleDiagnostic(4, "analyze-string/regex", 0);
        this.setRegex(TypeChecker.staticTypeCheck(this.getRegex(), SequenceType.SINGLE_STRING, false, role, visitor));
        role = new RoleDiagnostic(4, "analyze-string/flags", 0);
        this.setFlags(TypeChecker.staticTypeCheck(this.getFlags(), SequenceType.SINGLE_STRING, false, role, visitor));
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.selectOp.optimize(visitor, contextInfo);
        this.regexOp.optimize(visitor, contextInfo);
        this.flagsOp.optimize(visitor, contextInfo);
        if (this.matchingOp != null) {
            this.matchingOp.optimize(visitor, new ContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        if (this.nonMatchingOp != null) {
            this.nonMatchingOp.optimize(visitor, new ContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        if (this.pattern == null && this.getRegex() instanceof StringLiteral && this.getFlags() instanceof StringLiteral) {
            try {
                String regex = ((StringLiteral)this.getRegex()).getStringValue();
                String flagstr = ((StringLiteral)this.getFlags()).getStringValue();
                String hostLang = visitor.getStaticContext().getXPathVersion() >= 30 ? "XP30" : "XP20";
                ArrayList<String> warnings = new ArrayList<String>();
                this.pattern = Version.platform.compileRegularExpression(regex, flagstr.toString(), hostLang, warnings);
                for (String w : warnings) {
                    visitor.getStaticContext().issueWarning(w, this.getLocation());
                }
                if (!(this.isAllow30features() && this.useXsltErrorCodes || !this.pattern.matches(""))) {
                    this.pattern = Version.platform.compileRegularExpression("x", "", "XP20", warnings);
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", this.useXsltErrorCodes ? "XTDE1150" : "FORX0003");
                }
            }
            catch (XPathException err) {
                if ("XTDE1150".equals(err.getErrorCodeLocalPart())) {
                    throw err;
                }
                if ("FORX0001".equals(err.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + err, this.useXsltErrorCodes ? "XTDE1145" : "FORX0001");
                }
                this.invalidRegex("Error in regular expression: " + err, this.useXsltErrorCodes ? "XTDE1140" : err.getErrorCodeLocalPart());
            }
        }
        return this;
    }

    private void invalidRegex(String message, String errorCode) throws XPathException {
        this.pattern = null;
        XPathException err = new XPathException(message, errorCode);
        err.setLocation(this.getLocation());
        throw err;
    }

    @Override
    public Expression copy() {
        AnalyzeString a2 = new AnalyzeString(this.copy(this.getSelect()), this.copy(this.getRegex()), this.copy(this.getFlags()), this.copy(this.getMatching()), this.copy(this.getNonMatching()), this.pattern);
        ExpressionTool.copyLocationInfo(this, a2);
        return a2;
    }

    private Expression copy(Expression exp) {
        return exp == null ? null : exp.copy();
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        if (this.getMatching() != null) {
            this.getMatching().checkPermittedContents(parentType, false);
        }
        if (this.getNonMatching() != null) {
            this.getNonMatching().checkPermittedContents(parentType, false);
        }
    }

    @Override
    public ItemType getItemType() {
        if (this.getMatching() != null) {
            if (this.getNonMatching() != null) {
                TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                return Type.getCommonSuperType(this.getMatching().getItemType(), this.getNonMatching().getItemType(), th);
            }
            return this.getMatching().getItemType();
        }
        if (this.getNonMatching() != null) {
            return this.getNonMatching().getItemType();
        }
        return ErrorType.getInstance();
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.getSelect().getDependencies();
        dependencies |= this.getRegex().getDependencies();
        dependencies |= this.getFlags().getDependencies();
        if (this.getMatching() != null) {
            dependencies |= this.getMatching().getDependencies() & 0xFFFFFFA1;
        }
        if (this.getNonMatching() != null) {
            dependencies |= this.getNonMatching().getDependencies() & 0xFFFFFFA1;
        }
        return dependencies;
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        this.setSelect(this.doPromotion(this.getSelect(), offer));
        this.setRegex(this.doPromotion(this.getRegex(), offer));
        this.setFlags(this.doPromotion(this.getFlags(), offer));
        if (this.getMatching() != null) {
            this.setMatching(this.doPromotion(this.getMatching(), offer));
        }
        if (this.getNonMatching() != null) {
            this.setNonMatching(this.doPromotion(this.getNonMatching(), offer));
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item it;
        RegexIterator iter = this.getRegexIterator(context);
        FocusTrackingIterator focusIter = new FocusTrackingIterator(iter);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(focusIter);
        c2.setCurrentRegexIterator(iter);
        while ((it = focusIter.next()) != null) {
            if (iter.isMatching()) {
                if (this.getMatching() == null) continue;
                this.getMatching().process(c2);
                continue;
            }
            if (this.getNonMatching() == null) continue;
            this.getNonMatching().process(c2);
        }
        return null;
    }

    private RegexIterator getRegexIterator(XPathContext context) throws XPathException {
        CharSequence input = this.getSelect().evaluateAsString(context);
        RegularExpression re = this.pattern;
        if (re == null) {
            CharSequence flagstr = this.getFlags().evaluateAsString(context);
            String dialect = this.getRetainedStaticContext().getXPathVersion() >= 30 ? "XP30" : "XP20";
            re = Version.platform.compileRegularExpression(this.getRegex().evaluateAsString(context), flagstr.toString(), dialect, null);
            if ((dialect.equals("XP20") || !this.useXsltErrorCodes) && re.matches("")) {
                this.dynamicError("The regular expression must not be one that matches a zero-length string", this.useXsltErrorCodes ? "XTDE1150" : "FORX0003", context);
            }
        }
        return re.analyze(input);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        RegexIterator iter = this.getRegexIterator(context);
        FocusTrackingIterator focus = new FocusTrackingIterator(iter);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(focus);
        c2.setCurrentRegexIterator(iter);
        AnalyzeMappingFunction fn = new AnalyzeMappingFunction(iter, c2, this.getNonMatching(), this.getMatching());
        return new ContextMappingIterator(fn, c2);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("analyzeString", this);
        out.setChildRole("select");
        this.getSelect().export(out);
        out.setChildRole("regex");
        this.getRegex().export(out);
        out.setChildRole("flags");
        this.getFlags().export(out);
        if (this.getMatching() != null) {
            out.setChildRole("matching");
            this.getMatching().export(out);
        }
        if (this.getNonMatching() != null) {
            out.setChildRole("nonMatching");
            this.getNonMatching().export(out);
        }
        out.endElement();
    }
}

