/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public final class IsLastExpression
extends Expression {
    private boolean condition;

    public IsLastExpression(boolean condition) {
        this.condition = condition;
    }

    public boolean getCondition() {
        return this.condition;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.condition == c.isAtLast());
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 12;
    }

    public Expression copy() {
        IsLastExpression exp = new IsLastExpression(this.condition);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean equals(Object other) {
        return other instanceof IsLastExpression && ((IsLastExpression)other).condition == this.condition;
    }

    public int hashCode() {
        return this.condition ? 594252192 : -1989438816;
    }

    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("isLast", this);
        destination.emitAttribute("test", this.condition ? "1" : "0");
        destination.endElement();
    }

    public String toString() {
        if (this.condition) {
            return "position() eq last()";
        }
        return "position() ne last()";
    }
}

