/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executable {
    private Configuration config;
    private SpaceStrippingRule stripperRules;
    private boolean stripsWhitespace;
    private KeyManager keyManager;
    private SlotManager globalVariableMap;
    private List<GlobalVariable> compiledGlobalVariables;
    private Properties defaultOutputProperties;
    private int largestPatternStackFrame = 0;
    private CharacterMapIndex characterMapIndex;
    private LocationMap locationMap = new LocationMap();
    private HashMap<String, List<QueryModule>> queryLibraryModules;
    private HashSet<String> queryLocationHintsProcessed;
    private boolean stripsInputTypeAnnotations;
    private FunctionLibraryList functionLibrary;
    private int hostLanguage = 50;
    private boolean allowXPath30 = false;
    private HashSet<StructuredQName> requiredParams = null;
    private HashMap<StructuredQName, Properties> outputDeclarations = null;
    private boolean createsSecondaryResult = false;
    private boolean schemaAware = false;
    private GlobalVariable initialContextItemVariable = null;

    public Executable(Configuration config) {
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setHostLanguage(int language, boolean allowXPath30) {
        this.hostLanguage = language;
        this.allowXPath30 = allowXPath30;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public boolean isAllowXPath30() {
        return this.allowXPath30;
    }

    public FunctionLibraryList getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibraryList functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void setCharacterMapIndex(CharacterMapIndex cmi) {
        this.characterMapIndex = cmi;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new CharacterMapIndex();
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(SpaceStrippingRule rules) {
        this.stripperRules = rules;
    }

    public SpaceStrippingRule getStripperRules() {
        return this.stripperRules == null ? NoElementsSpaceStrippingRule.getInstance() : this.stripperRules;
    }

    public void setStripsWhitespace(boolean strips) {
        this.stripsWhitespace = strips;
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setStripsInputTypeAnnotations(boolean strips) {
        this.stripsInputTypeAnnotations = strips;
    }

    public boolean stripsInputTypeAnnotations() {
        return this.stripsInputTypeAnnotations;
    }

    public void setKeyManager(KeyManager km) {
        this.keyManager = km;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setOutputProperties(StructuredQName qName, Properties properties) {
        if (this.outputDeclarations == null) {
            this.outputDeclarations = new HashMap(5);
        }
        this.outputDeclarations.put(qName, properties);
    }

    public Properties getOutputProperties(StructuredQName qName) {
        if (this.outputDeclarations == null) {
            return null;
        }
        return this.outputDeclarations.get(qName);
    }

    public void addQueryLibraryModule(QueryModule module) {
        String uri;
        List<QueryModule> existing;
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        if ((existing = this.queryLibraryModules.get(uri = module.getModuleNamespace())) == null) {
            existing = new ArrayList<QueryModule>(5);
            existing.add(module);
            this.queryLibraryModules.put(uri, existing);
        } else {
            existing.add(module);
        }
    }

    public List<QueryModule> getQueryLibraryModules(String namespace) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return this.queryLibraryModules.get(namespace);
    }

    public QueryModule getQueryModuleWithSystemId(String systemId, QueryModule topModule) {
        if (systemId.equals(topModule.getSystemId())) {
            return topModule;
        }
        Iterator miter = this.getQueryLibraryModules();
        while (miter.hasNext()) {
            QueryModule sqc = (QueryModule)miter.next();
            String uri = sqc.getSystemId();
            if (uri == null || !uri.equals(systemId)) continue;
            return sqc;
        }
        return null;
    }

    public Iterator getQueryLibraryModules() {
        if (this.queryLibraryModules == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<QueryModule> modules = new ArrayList<QueryModule>();
        for (List<QueryModule> queryModules : this.queryLibraryModules.values()) {
            modules.addAll(queryModules);
        }
        return modules.iterator();
    }

    public void addQueryLocationHintProcessed(String uri) {
        if (this.queryLocationHintsProcessed == null) {
            this.queryLocationHintsProcessed = new HashSet();
        }
        this.queryLocationHintsProcessed.add(uri);
    }

    public boolean isQueryLocationHintProcessed(String uri) {
        return this.queryLocationHintsProcessed != null && this.queryLocationHintsProcessed.contains(uri);
    }

    public void fixupQueryModules(QueryModule main, boolean checkForCycles) throws XPathException {
        Object contextItemVar;
        if (this.initialContextItemVariable == null) {
            GlobalParam var = new GlobalParam();
            var.setPackageData(main.getPackageData());
            var.setRequiredParam(false);
            ErrorExpression errorExpression = new ErrorExpression(new XPathException("Context item is absent", "XPDY0002"));
            errorExpression.setContainer(var);
            var.setSelectExpression(errorExpression);
            StructuredQName structuredQName = StandardNames.SAXON_CONTEXT_ITEM;
            var.setVariableQName(structuredQName);
            var.setRequiredType(SequenceType.SINGLE_ITEM);
            this.setInitialContextItemVariable(var);
            this.registerGlobalVariable(var);
            this.getGlobalVariableMap().allocateSlotNumber(structuredQName);
            contextItemVar = var;
        } else {
            contextItemVar = this.initialContextItemVariable;
        }
        main.bindUnboundVariables();
        if (this.queryLibraryModules != null) {
            for (List list : this.queryLibraryModules.values()) {
                for (QueryModule env : list) {
                    env.bindUnboundVariables();
                }
            }
        }
        List<GlobalVariable> varDefinitions = main.fixupGlobalVariables(main.getGlobalStackFrameMap(), (GlobalVariable)contextItemVar);
        main.bindUnboundFunctionCalls();
        if (this.queryLibraryModules != null) {
            for (List<QueryModule> list : this.queryLibraryModules.values()) {
                for (QueryModule env : list) {
                    env.bindUnboundFunctionCalls();
                }
            }
        }
        main.checkForCircularities(varDefinitions, main.getGlobalFunctionLibrary());
        main.fixupGlobalFunctions();
        if (checkForCycles) {
            Iterator iterator = this.getQueryLibraryModules();
            while (iterator.hasNext()) {
                QueryModule queryModule = (QueryModule)iterator.next();
                queryModule.lookForModuleCycles(new Stack<QueryModule>(), 1);
            }
        }
        main.typeCheckGlobalVariables(varDefinitions);
        main.optimizeGlobalFunctions();
    }

    public void setPatternSlotSpace(int patternLocals) {
        this.largestPatternStackFrame = patternLocals;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public List<GlobalVariable> getCompiledGlobalVariables() {
        return this.compiledGlobalVariables;
    }

    public void explainGlobalVariables(ExpressionPresenter presenter) {
        if (this.compiledGlobalVariables != null) {
            presenter.startElement("globalVariables");
            for (GlobalVariable var : this.compiledGlobalVariables) {
                Visibility vis;
                presenter.startElement("declareVariable");
                presenter.emitAttribute("name", var.getVariableQName().getDisplayName());
                if (var.getDeclaringComponent() != null && (vis = var.getDeclaringComponent().getVisibility()) != null) {
                    presenter.emitAttribute("visibility", vis.toString());
                }
                if (var.isAssignable()) {
                    presenter.emitAttribute("assignable", "true");
                }
                if (var.getSelectExpression() != null) {
                    var.getSelectExpression().explain(presenter);
                }
                presenter.endElement();
            }
            presenter.endElement();
        }
    }

    public void registerGlobalVariable(GlobalVariable variable) {
        if (this.compiledGlobalVariables == null) {
            this.compiledGlobalVariables = new ArrayList<GlobalVariable>(32);
        }
        this.compiledGlobalVariables.add(variable);
        if (variable.isRequiredParam()) {
            if (this.requiredParams == null) {
                this.requiredParams = new HashSet(5);
            }
            this.requiredParams.add(variable.getVariableQName());
        }
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap map) {
        this.locationMap = map;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void checkAllRequiredParamsArePresent(GlobalParameterSet params) throws XPathException {
        if (this.requiredParams == null) {
            return;
        }
        for (StructuredQName req : this.requiredParams) {
            if (params != null && params.get(req) != null) continue;
            XPathException err = new XPathException("No value supplied for required parameter " + req.getDisplayName());
            err.setErrorCode(this.getHostLanguage() == 51 ? "XPDY0002" : "XTDE0050");
            throw err;
        }
    }

    public void setCreatesSecondaryResult(boolean flag) {
        this.createsSecondaryResult = flag;
    }

    public boolean createsSecondaryResult() {
        return this.createsSecondaryResult;
    }

    public void setInitialContextItemVariable(GlobalVariable var) {
        this.initialContextItemVariable = var;
    }

    public GlobalVariable getInitialContextItemVariable() {
        return this.initialContextItemVariable;
    }

    public void setSchemaAware(boolean aware) {
        if (aware) {
            this.config.checkLicensedFeature(1, "schema-aware processing");
        }
        this.schemaAware = aware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }
}

