/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.IAccumulatorManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStylesheet
extends Executable {
    private HashMap<URI, PreparedStylesheet> nextStylesheetCache;
    private RuleManager ruleManager;
    private HashMap<StructuredQName, Template> namedTemplateTable;
    private Map<SymbolicName, Component> componentIndex;
    private IAccumulatorManager accumulatorManager = null;
    private FunctionLibraryList stylesheetFunctions;
    private StructuredQName defaultInitialTemplate;
    private StructuredQName defaultInitialMode;
    private int recoveryPolicy;
    private String messageReceiverClassName;
    private OutputURIResolver outputURIResolver;
    private GlobalParameterSet compileTimeParams;

    public FunctionLibraryList getStylesheetFunctions() {
        return this.stylesheetFunctions;
    }

    public PreparedStylesheet(Compilation compilation) {
        super(compilation.getConfiguration());
        this.setAccumulatorManager(compilation.getStyleNodeFactory(true).makeAccumulatorManager());
        CompilerInfo compilerInfo = compilation.getCompilerInfo();
        RuleManager rm = new RuleManager();
        rm.setRecoveryPolicy(compilerInfo.getRecoveryPolicy());
        this.setRuleManager(rm);
        this.setHostLanguage(50, compilation.getVersion().equals(DecimalValue.THREE));
        this.setSchemaAware(compilerInfo.isSchemaAware());
        if (compilerInfo.getErrorListener() == null) {
            compilerInfo.setErrorListener(this.getConfiguration().getErrorListener());
        }
        this.defaultInitialMode = compilerInfo.getDefaultInitialMode();
        this.defaultInitialTemplate = compilerInfo.getDefaultInitialTemplate();
        this.recoveryPolicy = compilerInfo.getRecoveryPolicy();
        this.messageReceiverClassName = compilerInfo.getMessageReceiverClassName();
        this.outputURIResolver = compilerInfo.getOutputURIResolver();
        this.compileTimeParams = compilerInfo.getParameters();
        this.setLocationMap(compilation.getLocationMap());
    }

    public Controller newController() {
        Configuration config = this.getConfiguration();
        Controller c = new Controller(config, this);
        c.setMessageReceiverClassName(this.messageReceiverClassName);
        c.setOutputURIResolver(this.outputURIResolver);
        c.setRecoveryPolicy(this.recoveryPolicy);
        if (this.defaultInitialTemplate != null) {
            try {
                c.setInitialTemplate(this.defaultInitialTemplate);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (this.defaultInitialMode != null) {
            try {
                c.setInitialMode(this.defaultInitialMode);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return c;
    }

    public IAccumulatorManager getAccumulatorManager() {
        return this.accumulatorManager;
    }

    public void setAccumulatorManager(IAccumulatorManager accumulatorManager) {
        this.accumulatorManager = accumulatorManager;
    }

    public GlobalParameterSet getCompileTimeParams() {
        return this.compileTimeParams;
    }

    public void setRuleManager(RuleManager rm) {
        this.ruleManager = rm;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Template getNamedTemplate(StructuredQName qName) {
        if (this.namedTemplateTable == null) {
            return null;
        }
        return this.namedTemplateTable.get(qName);
    }

    public void putNamedTemplate(StructuredQName templateName, Template template) {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap(32);
        }
        this.namedTemplateTable.put(templateName, template);
    }

    public FunctionItem getFunction(StructuredQName qName, int arity) {
        SymbolicName s = new SymbolicName(155, qName, arity);
        return null;
    }

    public void setComponentIndex(Map<SymbolicName, Component> index) {
        this.componentIndex = index;
    }

    public Component getComponent(SymbolicName name) {
        return this.componentIndex.get(name);
    }

    public Iterator<Template> iterateNamedTemplates() {
        if (this.namedTemplateTable == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.namedTemplateTable.values().iterator();
    }

    public void explainNamedTemplates(ExpressionPresenter presenter) {
        presenter.startElement("namedTemplates");
        if (this.namedTemplateTable != null) {
            for (Template t : this.namedTemplateTable.values()) {
                presenter.startElement("template");
                presenter.emitAttribute("name", t.getTemplateName().getDisplayName());
                presenter.emitAttribute("line", t.getLineNumber() + "");
                presenter.emitAttribute("module", t.getSystemId());
                if (t.getBody() != null) {
                    t.getBody().explain(presenter);
                }
                presenter.endElement();
            }
        }
        presenter.endElement();
    }

    public Properties getOutputProperties() {
        Properties details = this.getDefaultOutputProperties();
        return new Properties(details);
    }

    public PreparedStylesheet getCachedStylesheet(String href, String baseURI) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        PreparedStylesheet result = null;
        if (abs != null && this.nextStylesheetCache != null) {
            result = this.nextStylesheetCache.get(abs);
        }
        return result;
    }

    public void putCachedStylesheet(String href, String baseURI, PreparedStylesheet pss) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (abs != null) {
            if (this.nextStylesheetCache == null) {
                this.nextStylesheetCache = new HashMap(4);
            }
            this.nextStylesheetCache.put(abs, pss);
        }
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.startElement("stylesheet");
        this.getKeyManager().explainKeys(presenter);
        this.explainGlobalVariables(presenter);
        this.ruleManager.explainTemplateRules(presenter);
        this.explainNamedTemplates(presenter);
        FunctionLibraryList libList = this.getFunctionLibrary();
        List<FunctionLibrary> libraryList = libList.getLibraryList();
        presenter.startElement("functions");
        for (FunctionLibrary lib : libraryList) {
            if (!(lib instanceof ExecutableFunctionLibrary)) continue;
            Iterator<UserFunction> f = ((ExecutableFunctionLibrary)lib).iterateFunctions();
            while (f.hasNext()) {
                UserFunction func = f.next();
                presenter.startElement("function");
                presenter.emitAttribute("name", func.getFunctionName().getDisplayName());
                presenter.emitAttribute("line", func.getLineNumber() + "");
                presenter.emitAttribute("module", func.getSystemId());
                func.getBody().explain(presenter);
                presenter.endElement();
            }
        }
        presenter.endElement();
        presenter.endElement();
        presenter.close();
    }

    public void setStylesheetFunctionLibrary(FunctionLibraryList stylesheetFunctions) {
        this.stylesheetFunctions = stylesheetFunctions;
    }
}

